/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.erasureCode;

import io.hops.hopsworks.common.dao.jobs.description.Jobs;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.common.jobs.erasureCode.ErasureCodeJobConfiguration;
import io.hops.hopsworks.common.jobs.execution.HopsJob;
import io.hops.hopsworks.common.jobs.yarn.YarnJobsMonitor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import org.apache.hadoop.yarn.client.api.YarnClient;

public class ErasureCodeJob
extends HopsJob {
    private static final Logger logger = Logger.getLogger(ErasureCodeJob.class.getName());
    private ErasureCodeJobConfiguration jobConfig;

    public ErasureCodeJob(Jobs job, AsynchronousJobExecutor services, Users user, String hadoopDir, YarnJobsMonitor jobsMonitor) {
        super(job, services, user, hadoopDir, jobsMonitor);
        if (!(job.getJobConfig() instanceof ErasureCodeJobConfiguration)) {
            throw new IllegalArgumentException("JobDescription must contain an ErasureCodeJobConfiguration object. Received: " + job.getJobConfig().getClass());
        }
        this.jobConfig = (ErasureCodeJobConfiguration)job.getJobConfig();
    }

    @Override
    protected boolean setupJob(DistributedFileSystemOps dfso, YarnClient yarnClient) {
        if (this.jobConfig.getAppName() == null || this.jobConfig.getAppName().isEmpty()) {
            this.jobConfig.setAppName("Untitled Erasure coding Job");
        }
        return true;
    }

    @Override
    protected void runJob(DistributedFileSystemOps udfso, DistributedFileSystemOps dfso) {
        boolean jobSucceeded = false;
        try {
            jobSucceeded = dfso.compress(this.jobConfig.getFilePath());
        }
        catch (IOException | NotFoundException e) {
            jobSucceeded = false;
        }
        if (jobSucceeded) {
            logger.log(Level.INFO, "File compression was successful");
            return;
        }
        logger.log(Level.INFO, "File compression was not successful");
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void writeToLogs(String message, Exception e) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void writeToLogs(String message) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

