/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;

@Stateless
public class BaseHadoopClientsService {
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    protected Settings settings;
    private Configuration sslConf;
    private String superKeystorePath;
    private String superKeystorePassword;
    private String superTrustStorePath;
    private String superTrustStorePassword;
    private final Logger LOG = Logger.getLogger(BaseHadoopClientsService.class.getName());

    @PostConstruct
    public void init() {
        String confDir = this.settings.getHadoopConfDir();
        File coreSite = new File(confDir, "core-site.xml");
        if (!coreSite.exists()) {
            this.handleMissingConf("core-site.xml", confDir);
        }
        Configuration conf = new Configuration();
        conf.addResource(new Path(coreSite.getAbsolutePath()));
        this.sslConf = new Configuration(false);
        String hadoopConfDir = this.settings.getHadoopConfDir();
        File serverSSLConf = new File(hadoopConfDir, conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
        this.sslConf.addResource(new Path(serverSSLConf.getAbsolutePath()));
        this.superKeystorePath = this.sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.location"));
        this.superKeystorePassword = this.sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"));
        this.superTrustStorePath = this.sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.location"));
        this.superTrustStorePassword = this.sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.password"));
    }

    public String getSuperKeystorePath() {
        return this.superKeystorePath;
    }

    public String getSuperKeystorePassword() {
        return this.superKeystorePassword;
    }

    public String getSuperTrustStorePath() {
        return this.superTrustStorePath;
    }

    public String getSuperTrustStorePassword() {
        return this.superTrustStorePassword;
    }

    public String getProjectSpecificUserCertPassword(String username) throws CryptoPasswordNotFoundException {
        if (username != null) {
            String[] project_username = username.split("__", 2);
            CertificateMaterializer.CryptoMaterial cryptoMaterial = this.certificateMaterializer.getUserMaterial(project_username[1], project_username[0]);
            return new String(cryptoMaterial.getPassword());
        }
        throw new RuntimeException("Username cannot be null!");
    }

    public void configureTlsForProjectSpecificUser(String username, String transientDir, Configuration conf) throws CryptoPasswordNotFoundException {
        String password = this.getProjectSpecificUserCertPassword(username);
        String prefix = Paths.get(transientDir, username).toString();
        String kstorePath = prefix + "__kstore.jks";
        String tstorePath = prefix + "__tstore.jks";
        HopsSSLSocketFactory.setTlsConfiguration((String)kstorePath, (String)password, (String)tstorePath, (String)password, (Configuration)conf);
    }

    public void materializeCertsForNonSuperUser(String username) {
        String[] tokens;
        if (username != null && (tokens = username.split("__", 2)).length == 2) {
            try {
                this.certificateMaterializer.materializeCertificatesLocal(tokens[1], tokens[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error while materializing user certificates " + ex.getMessage(), ex);
            }
        }
    }

    public void removeNonSuperUserCertificate(String username) {
        String[] tokens;
        if (username != null && (tokens = username.split("__", 2)).length == 2) {
            this.certificateMaterializer.removeCertificatesLocal(tokens[1], tokens[0]);
        }
    }

    private void handleMissingConf(String confName, String confDir) throws IllegalStateException {
        this.LOG.log(Level.SEVERE, "Unable to locate {0} in {1}", new Object[]{confName, confDir});
        throw new IllegalStateException("Unable to locate " + confName + " in " + confDir);
    }
}

