/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.host;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class HostsFacade
extends AbstractFacade<Hosts> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public HostsFacade() {
        super(Hosts.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<Hosts> findAllHosts() {
        TypedQuery query = this.em.createNamedQuery("Hosts.find", Hosts.class);
        return query.getResultList();
    }

    public Hosts findByHostIp(String hostIp) {
        TypedQuery query = this.em.createNamedQuery("Hosts.findBy-HostIp", Hosts.class).setParameter("hostIp", (Object)hostIp);
        try {
            return (Hosts)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public Hosts findByHostname(String hostname) {
        TypedQuery query = this.em.createNamedQuery("Hosts.findBy-Hostname", Hosts.class).setParameter("hostname", (Object)hostname);
        try {
            return (Hosts)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public String findCPUHost() {
        List<Hosts> hosts = this.findAllHosts();
        for (Hosts host : hosts) {
            if (host.getNumGpus() != 0 || !host.getCondaEnabled().booleanValue()) continue;
            return host.getHostname();
        }
        return null;
    }

    public String findGPUHost() {
        List<Hosts> hosts = this.findAllHosts();
        for (Hosts host : hosts) {
            if (host.getNumGpus() <= 0 || !host.getCondaEnabled().booleanValue()) continue;
            return host.getHostname();
        }
        return null;
    }

    public boolean hostExists(String hostId) {
        try {
            return this.findByHostname(hostId) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Hosts storeHost(Hosts host) {
        return (Hosts)this.em.merge((Object)host);
    }

    public boolean removeByHostname(String hostname) {
        Hosts host = this.findByHostname(hostname);
        if (host != null) {
            this.em.remove((Object)host);
            return true;
        }
        return false;
    }

    public List<Hosts> getCondaHosts(LibraryFacade.MachineType machineType) {
        TypedQuery query;
        switch (machineType) {
            case CPU: {
                query = this.em.createNamedQuery("Hosts.findBy-conda-enabled-cpu", Hosts.class);
                break;
            }
            case GPU: {
                query = this.em.createNamedQuery("Hosts.findBy-conda-enabled-gpu", Hosts.class);
                break;
            }
            default: {
                query = this.em.createNamedQuery("Hosts.findBy-conda-enabled", Hosts.class);
            }
        }
        return query.getResultList();
    }

    public Long countHosts() {
        TypedQuery query = this.em.createNamedQuery("Host.Count", Long.class);
        return (Long)query.getSingleResult();
    }

    public Long totalCores() {
        TypedQuery query = this.em.createNamedQuery("Host.TotalCores", Long.class);
        return (Long)query.getSingleResult();
    }

    public Long totalGPUs() {
        TypedQuery query = this.em.createNamedQuery("Host.TotalGPUs", Long.class);
        return (Long)query.getSingleResult();
    }

    public Long totalMemoryCapacity() {
        TypedQuery query = this.em.createNamedQuery("Host.TotalMemoryCapacity", Long.class);
        return (Long)query.getSingleResult();
    }
}

