/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter.config;

import com.google.common.io.Files;
import io.hops.hopsworks.common.dao.hdfs.HdfsLeDescriptorsFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jupyter.JupyterProject;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettings;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterConfigFilesGenerator;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterDTO;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterManager;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterPaths;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.integrations.LocalhostStereotype;
import io.hops.hopsworks.common.jupyter.TokenGenerator;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;

@Stateless
@LocalhostStereotype
public class JupyterProcessMgr
implements JupyterManager {
    private static final Logger LOGGER = Logger.getLogger(JupyterProcessMgr.class.getName());
    private static final int TOKEN_LENGTH = 48;
    private static final String JUPYTER_HOST_TEMPLATE = "http://%s:%d";
    private static final String PING_PATH = "/hopsworks-api/jupyter/%d/api/status";
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsLeDescriptorsFacade hdfsLeFacade;
    @EJB
    private JupyterFacade jupyterFacade;
    @EJB
    private JupyterConfigFilesGenerator jupyterConfigFilesGenerator;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private HttpClient httpClient;
    private String jupyterHost;

    @PostConstruct
    public void init() {
        this.jupyterHost = this.settings.getJupyterHost();
    }

    @PreDestroy
    public void preDestroy() {
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public JupyterDTO startJupyterServer(Project project, String secretConfig, String hdfsUser, Users user, JupyterSettings js, String allowOrigin) throws ServiceException {
        String prog = this.settings.getHopsworksDomainDir() + "/bin/jupyter.sh";
        Integer port = ThreadLocalRandom.current().nextInt(40000, 59999);
        String realName = user.getFname() + " " + user.getLname();
        JupyterPaths jp = this.jupyterConfigFilesGenerator.generateConfiguration(project, secretConfig, hdfsUser, realName, this.hdfsLeFacade.getRPCEndpoint(), js, port, allowOrigin);
        String secretDir = this.settings.getStagingDir() + "/private_dirs/" + js.getSecret();
        String token = TokenGenerator.generateToken(48);
        Long pid = 0L;
        for (int maxTries = 5; maxTries > 0; --maxTries) {
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("start").addCommand(jp.getNotebookPath()).addCommand(this.settings.getHadoopSymbolicLinkDir() + "-" + this.settings.getHadoopVersion()).addCommand(this.settings.getJavaHome()).addCommand(this.settings.getAnacondaProjectDir(project)).addCommand(port.toString()).addCommand(hdfsUser + "-" + port + ".log").addCommand(secretDir).addCommand(jp.getCertificatesDir()).addCommand(hdfsUser).addCommand(token).addCommand(js.getMode().getValue()).redirectErrorStream(true).setCurrentWorkingDirectory(new File(jp.getNotebookPath())).setWaitTimeout(20L, TimeUnit.SECONDS).build();
            String pidfile = jp.getRunDirPath() + "/jupyter.pid";
            try {
                ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                if (processResult.getExitCode() != 0) {
                    String errorMsg = "Could not start Jupyter server. Exit code: " + processResult.getExitCode() + " Error: " + processResult.getStdout();
                    LOGGER.log(Level.SEVERE, errorMsg);
                    throw new IOException(errorMsg);
                }
                String pidContents = Files.readFirstLine((File)new File(pidfile), (Charset)Charset.defaultCharset());
                pid = Long.parseLong(pidContents);
                return new JupyterDTO(port, token, pid, secretConfig, jp.getCertificatesDir());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Problem executing shell script to start Jupyter server", ex);
                continue;
            }
        }
        String errorMsg = "Failed to start Jupyter";
        throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_START_ERROR, Level.SEVERE, errorMsg, errorMsg + " for project " + project);
    }

    @Override
    public void waitForStartup(Project project, Users user) throws TimeoutException {
    }

    @Override
    public void stopOrphanedJupyterServer(Long pid, Integer port) throws ServiceException {
        this.stopJupyterServer(null, null, "Orphaned", "", pid, port);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void stopJupyterServer(Project project, Users user, String hdfsUsername, String jupyterHomePath, Long pid, Integer port) throws ServiceException {
        if (jupyterHomePath == null || pid == null || port == null) {
            throw new IllegalArgumentException("Invalid arguments when stopping the Jupyter Server.");
        }
        try {
            this.jupyterFacade.remove(hdfsUsername, port);
        }
        catch (Exception e) {
            LOGGER.severe("Problem when removing jupyter notebook entry from jupyter_project table: " + jupyterHomePath);
        }
        String prog = this.settings.getHopsworksDomainDir() + "/bin/jupyter.sh";
        if (jupyterHomePath.isEmpty()) {
            jupyterHomePath = "''";
        }
        int exitValue = 0;
        Integer id = 1;
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("kill").addCommand(jupyterHomePath).addCommand(pid.toString()).addCommand(port.toString()).setWaitTimeout(10L, TimeUnit.SECONDS);
        if (!LOGGER.isLoggable(Level.FINE)) {
            pdBuilder.ignoreOutErrStreams(true);
        }
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(pdBuilder.build());
            LOGGER.log(Level.FINE, processResult.getStdout());
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_STOP_ERROR, Level.SEVERE, "exitValue: " + exitValue, ex.getMessage(), (Throwable)ex);
        }
        if (exitValue != 0) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_STOP_ERROR, Level.SEVERE, "exitValue: " + exitValue);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void projectCleanup(Project project) {
        this.projectCleanup(this.settings, LOGGER, this.osProcessExecutor, project);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public boolean ping(JupyterProject jupyterProject) {
        Integer jupyterPort = jupyterProject.getPort();
        HttpHost host = HttpHost.create((String)String.format(JUPYTER_HOST_TEMPLATE, this.jupyterHost, jupyterPort));
        String pingPath = String.format(PING_PATH, jupyterPort);
        try {
            URI authPath = new URIBuilder(pingPath).addParameter("token", jupyterProject.getToken()).build();
            HttpGet httpRequest = new HttpGet(authPath);
            return this.httpClient.execute(host, (HttpRequest)httpRequest, new ResponseHandler<Boolean>(){

                public Boolean handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    return status == 200;
                }
            });
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Could not parse URI to ping Jupyter server", ex);
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<JupyterProject> getAllNotebooks() {
        List<JupyterProject> allNotebooks = this.jupyterFacade.getAllNotebookServers();
        this.executeJupyterCommand("list");
        File file = new File("/tmp/jupyterNotebookServer.pids");
        ArrayList<Long> pidsRunning = new ArrayList<Long>();
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                pidsRunning.add(Long.parseLong(line));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warning("Invalid pids in file: /tmp/jupyterNotebookServer.pids");
        }
        ArrayList<Long> pidsOrphaned = new ArrayList<Long>();
        pidsOrphaned.addAll(pidsRunning);
        for (Long pid : pidsRunning) {
            boolean foundPid = false;
            for (JupyterProject jp : allNotebooks) {
                if (pid.longValue() == jp.getPid()) {
                    foundPid = true;
                }
                if (!foundPid) continue;
                pidsOrphaned.remove(pid);
            }
        }
        for (Long pid : pidsOrphaned) {
            JupyterProject jp = new JupyterProject();
            jp.setPid(pid);
            jp.setPort(0);
            jp.setHdfsUserId(-1);
            allNotebooks.add(jp);
        }
        file.deleteOnExit();
        return allNotebooks;
    }

    private int executeJupyterCommand(String ... args) {
        int exitValue;
        if (args == null || args.length == 0) {
            return -99;
        }
        Integer id = 1;
        String prog = this.settings.getHopsworksDomainDir() + "/bin/jupyter.sh";
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog);
        for (String arg : args) {
            pdBuilder.addCommand(arg);
        }
        pdBuilder.setWaitTimeout(20L, TimeUnit.SECONDS);
        if (!LOGGER.isLoggable(Level.FINE)) {
            pdBuilder.ignoreOutErrStreams(true);
        }
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(pdBuilder.build());
            LOGGER.log(Level.FINE, processResult.getStdout());
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Problem checking if Jupyter Notebook server is running: {0}", ex);
            exitValue = -2;
        }
        return exitValue;
    }
}

