/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.feature;

import io.hops.hopsworks.common.dao.featurestore.feature.FeaturestoreFeature;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.feature.FeaturestoreFeatureFacade;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreFeatureController {
    @EJB
    private FeaturestoreFeatureFacade featurestoreFeatureFacade;

    public void updateTrainingDatasetFeatures(TrainingDataset trainingDataset, List<FeatureDTO> features) {
        if (features == null) {
            return;
        }
        this.removeFeatures((List)trainingDataset.getFeatures());
        this.insertTrainingDatasetFeatures(trainingDataset, features);
    }

    private void removeFeatures(List<FeaturestoreFeature> featurestoreFeatures) {
        this.featurestoreFeatureFacade.deleteListOfFeatures(featurestoreFeatures.stream().map(f -> f.getId()).collect(Collectors.toList()));
    }

    private void insertTrainingDatasetFeatures(TrainingDataset trainingDataset, List<FeatureDTO> features) {
        List<FeaturestoreFeature> featurestoreFeatures = this.convertFeaturesToTrainingDatasetFeatures(trainingDataset, features);
        this.featurestoreFeatureFacade.persist(featurestoreFeatures);
    }

    private List<FeaturestoreFeature> convertFeaturesToTrainingDatasetFeatures(TrainingDataset trainingDataset, List<FeatureDTO> features) {
        return features.stream().map(f -> {
            FeaturestoreFeature featurestoreFeature = new FeaturestoreFeature();
            featurestoreFeature.setName(f.getName());
            featurestoreFeature.setTrainingDataset(trainingDataset);
            featurestoreFeature.setDescription(f.getDescription());
            featurestoreFeature.setPrimary(f.getPrimary() != false ? 1 : 0);
            featurestoreFeature.setType(f.getType());
            return featurestoreFeature;
        }).collect(Collectors.toList());
    }

    public void updateOnDemandFeaturegroupFeatures(OnDemandFeaturegroup onDemandFeaturegroup, List<FeatureDTO> features) {
        if (features == null) {
            return;
        }
        this.removeFeatures((List)onDemandFeaturegroup.getFeatures());
        this.insertOnDemandFeaturegroupFeatures(onDemandFeaturegroup, features);
    }

    private void insertOnDemandFeaturegroupFeatures(OnDemandFeaturegroup onDemandFeaturegroup, List<FeatureDTO> features) {
        List<FeaturestoreFeature> featurestoreFeatures = this.convertFeaturesToOnDemandFeaturegroupFeatures(onDemandFeaturegroup, features);
        this.featurestoreFeatureFacade.persist(featurestoreFeatures);
    }

    private List<FeaturestoreFeature> convertFeaturesToOnDemandFeaturegroupFeatures(OnDemandFeaturegroup onDemandFeaturegroup, List<FeatureDTO> features) {
        return features.stream().map(f -> {
            FeaturestoreFeature featurestoreFeature = new FeaturestoreFeature();
            featurestoreFeature.setName(f.getName());
            featurestoreFeature.setOnDemandFeaturegroup(onDemandFeaturegroup);
            featurestoreFeature.setDescription(f.getDescription());
            featurestoreFeature.setPrimary(f.getPrimary() != false ? 1 : 0);
            featurestoreFeature.setType(f.getType());
            return featurestoreFeature;
        }).collect(Collectors.toList());
    }
}

