/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.common.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlSeeAlso(value={CachedFeaturegroupDTO.class, OnDemandFeaturegroupDTO.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CachedFeaturegroupDTO.class, name="OnlineFeaturegroupDTO"), @JsonSubTypes.Type(value=OnDemandFeaturegroupDTO.class, name="HopsfsTrainingDatasetDTO")})
public class FeaturegroupDTO
extends FeaturestoreEntityDTO {
    private FeaturegroupType featuregroupType;
    @XmlElement
    private Boolean descStatsEnabled;
    @XmlElement
    private Boolean featCorrEnabled;
    @XmlElement
    private Boolean featHistEnabled;
    @XmlElement
    private Boolean clusterAnalysisEnabled;
    @XmlElement
    private List<String> statisticColumns;
    @XmlElement
    private Integer numBins;
    @XmlElement
    private Integer numClusters;
    @XmlElement
    private String corrMethod;

    public FeaturegroupDTO() {
    }

    public FeaturegroupDTO(Featuregroup featuregroup) {
        super(featuregroup.getFeaturestore().getId(), featuregroup.getCreated(), featuregroup.getCreator(), featuregroup.getVersion(), (List)featuregroup.getStatistics(), (List)featuregroup.getJobs(), featuregroup.getId());
        this.featuregroupType = featuregroup.getFeaturegroupType();
        this.clusterAnalysisEnabled = featuregroup.isClusterAnalysisEnabled();
        this.descStatsEnabled = featuregroup.isDescStatsEnabled();
        this.featCorrEnabled = featuregroup.isFeatCorrEnabled();
        this.featHistEnabled = featuregroup.isFeatHistEnabled();
        List statColumns = (List)featuregroup.getStatisticColumns();
        this.statisticColumns = statColumns.stream().map(sc -> sc.getName()).collect(Collectors.toList());
        this.numBins = featuregroup.getNumBins();
        this.numClusters = featuregroup.getNumClusters();
        this.corrMethod = featuregroup.getCorrMethod();
    }

    public Boolean isDescStatsEnabled() {
        return this.descStatsEnabled;
    }

    public void setDescStatsEnabled(boolean descStatsEnabled) {
        this.descStatsEnabled = descStatsEnabled;
    }

    public Boolean isFeatCorrEnabled() {
        return this.featCorrEnabled;
    }

    public void setFeatCorrEnabled(boolean featCorrEnabled) {
        this.featCorrEnabled = featCorrEnabled;
    }

    public Boolean isFeatHistEnabled() {
        return this.featHistEnabled;
    }

    public void setFeatHistEnabled(boolean featHistEnabled) {
        this.featHistEnabled = featHistEnabled;
    }

    public Boolean isClusterAnalysisEnabled() {
        return this.clusterAnalysisEnabled;
    }

    public void setClusterAnalysisEnabled(boolean clusterAnalysisEnabled) {
        this.clusterAnalysisEnabled = clusterAnalysisEnabled;
    }

    public List<String> getStatisticColumns() {
        return this.statisticColumns;
    }

    public void setStatisticColumns(List<String> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    public Integer getNumBins() {
        return this.numBins;
    }

    public void setNumBins(Integer numBins) {
        this.numBins = numBins;
    }

    public Integer getNumClusters() {
        return this.numClusters;
    }

    public void setNumClusters(Integer numClusters) {
        this.numClusters = numClusters;
    }

    public String getCorrMethod() {
        return this.corrMethod;
    }

    public void setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
    }

    @XmlElement
    public FeaturegroupType getFeaturegroupType() {
        return this.featuregroupType;
    }

    public void setFeaturegroupType(FeaturegroupType featuregroupType) {
        this.featuregroupType = featuregroupType;
    }

    @Override
    public String toString() {
        return "FeaturegroupDTO{featuregroupType=" + (Object)((Object)this.featuregroupType) + ", descStatsEnabled=" + this.descStatsEnabled + ", featCorrEnabled=" + this.featCorrEnabled + ", featHistEnabled=" + this.featHistEnabled + ", clusterAnalysisEnabled=" + this.clusterAnalysisEnabled + ", statisticColumns=" + this.statisticColumns + ", numBins=" + this.numBins + ", numClusters=" + this.numClusters + ", corrMethod='" + this.corrMethod + '\'' + '}';
    }
}

