/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.host;

import io.hops.hopsworks.common.util.FormatUtils;
import java.io.Serializable;

public class MemoryInfo
implements Serializable {
    private Long used;
    private Long capacity;

    public MemoryInfo() {
    }

    public MemoryInfo(Long capacity, Long used) {
        this.used = used;
        this.capacity = capacity;
    }

    public long getUsed() {
        return this.used;
    }

    public void setCapacity(Long capacity) {
        this.capacity = capacity;
    }

    public void setUsed(Long used) {
        this.used = used;
    }

    public long getCapacity() {
        return this.capacity;
    }

    private double usagePercentage() {
        if (this.used == null || this.capacity == null) {
            return 0.0;
        }
        return (double)this.used.longValue() / (double)this.capacity.longValue() * 100.0;
    }

    public String getUsagePercentageString() {
        return String.format("%1.1f", this.usagePercentage()) + "%";
    }

    public String getUsageInfo() {
        FormatUtils f = new FormatUtils();
        if (this.used == null || this.capacity == null) {
            return "N/A";
        }
        return FormatUtils.storage(this.used) + " / " + FormatUtils.storage(this.capacity);
    }

    public String getPriority() {
        if (this.usagePercentage() > 75.0) {
            return "priorityHigh";
        }
        if (this.usagePercentage() > 25.0) {
            return "priorityMed";
        }
        return "priorityLow";
    }
}

