/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.commands;

import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.AnacondaRepo;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.dao.python.CondaCommands;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.dao.python.PythonDep;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.WebCommunication;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CommandsController {
    private static final Logger LOGGER = Logger.getLogger(CommandsController.class.getName());
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private Settings settings;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private WebCommunication web;
    @EJB
    private LibraryFacade libraryFacade;
    @Resource(lookup="concurrent/kagentExecutorService")
    ManagedExecutorService kagentExecutorService;

    public void deleteCommands(Project project, String lib) {
        this.condaCommandFacade.deleteCommandsForLibrary(project, lib);
    }

    public void deleteCommands(Project project) {
        this.condaCommandFacade.deleteCommandsForEnvironment(project);
    }

    public List<CondaCommands> retryFailedCondaOps(Project project) {
        List<CondaCommands> commands = this.condaCommandFacade.getFailedCommandsForProject(project);
        for (CondaCommands cc : commands) {
            cc.setStatus(CondaCommandFacade.CondaStatus.NEW);
            this.condaCommandFacade.update(cc);
        }
        return commands;
    }

    public List<CondaCommands> retryFailedCondaOps(Project project, String library) {
        List<CondaCommands> commands = this.condaCommandFacade.getFailedCommandsForProjectAndLib(project, library);
        for (CondaCommands cc : commands) {
            cc.setStatus(CondaCommandFacade.CondaStatus.NEW);
            this.condaCommandFacade.update(cc);
        }
        return commands;
    }

    public void deleteCommandsForProject(Project proj) {
        List<CondaCommands> commands = this.condaCommandFacade.getCommandsForProject(proj);
        if (commands == null) {
            return;
        }
        for (CondaCommands cc : commands) {
            this.condaCommandFacade.remove(cc);
        }
    }

    public void blockingCondaEnvironmentOp(CondaCommandFacade.CondaOp op, String proj, String arg, List<Hosts> hosts) {
        ArrayList<Future> waiters = new ArrayList<Future>();
        for (Hosts h : hosts) {
            LOGGER.log(Level.INFO, "Create anaconda enviornment for {0} on {1}", new Object[]{proj, h.getHostIp()});
            Future f = this.kagentExecutorService.submit((Runnable)new AnacondaTask(this.web, proj, h, op, arg));
            waiters.add(f);
        }
        for (Future f : waiters) {
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    public PythonDep condaOp(CondaCommandFacade.CondaOp op, CondaCommandFacade.CondaInstallType installType, LibraryFacade.MachineType machineType, Project proj, String channelUrl, String lib, String version) throws ServiceException, GenericException {
        PythonDep dep;
        List<Hosts> hosts = this.hostsFacade.getCondaHosts(machineType);
        if (hosts.size() == 0) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.HOST_TYPE_NOT_FOUND, Level.INFO, "capability:" + machineType.name());
        }
        try {
            AnacondaRepo repo = this.libraryFacade.getRepo(channelUrl, true);
            dep = this.libraryFacade.getOrCreateDep(repo, machineType, installType, lib, version, true, false);
            Collection<PythonDep> depsInProj = proj.getPythonDepCollection();
            if (depsInProj.contains(dep) && op == CondaCommandFacade.CondaOp.INSTALL) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PYTHON_LIB_ALREADY_INSTALLED, Level.FINE, "dep: " + dep.getDependency());
            }
            if (op == CondaCommandFacade.CondaOp.INSTALL || op == CondaCommandFacade.CondaOp.UPGRADE) {
                depsInProj.remove(dep);
                depsInProj.add(dep);
            }
            proj.setPythonDepCollection(depsInProj);
            this.projectFacade.update(proj);
            for (Hosts h : hosts) {
                CondaCommands cc = new CondaCommands(h, this.settings.getAnacondaUser(), op, CondaCommandFacade.CondaStatus.NEW, installType, machineType, proj, lib, version, channelUrl, new Date(), "", null, false);
                this.condaCommandFacade.save(cc);
            }
        }
        catch (Exception ex) {
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, "condaOp failed", ex.getMessage(), (Throwable)ex);
        }
        return dep;
    }

    public void updateCondaCommandStatus(Integer commandID, CondaCommandFacade.CondaStatus status, String arguments) throws ServiceException {
        this.updateCondaCommandStatus(commandID, status, null, null, arguments, null, null, null, null, null);
    }

    public void updateCondaCommandStatus(int commandId, CondaCommandFacade.CondaStatus condaStatus, CondaCommandFacade.CondaInstallType installType, LibraryFacade.MachineType machineType, String arg, String proj, CondaCommandFacade.CondaOp opType, String lib, String version, String channel) throws ServiceException {
        CondaCommands cc = this.condaCommandFacade.findCondaCommand(commandId);
        if (cc != null) {
            if (condaStatus == CondaCommandFacade.CondaStatus.SUCCESS) {
                this.condaCommandFacade.remove(cc);
                if (!CondaCommandFacade.CondaOp.isEnvOp(opType)) {
                    Project p = this.projectFacade.findByName(proj);
                    Collection<CondaCommands> ongoingCommands = p.getCondaCommandsCollection();
                    boolean finished = true;
                    for (CondaCommands c : ongoingCommands) {
                        if (c.getOp().compareTo(opType) != 0 || c.getLib().compareTo(lib) != 0 || c.getVersion().compareTo(version) != 0 || c.getInstallType().name().compareTo(installType.name()) != 0 || c.getChannelUrl().compareTo(channel) != 0 || c.getMachineType().name().compareTo(machineType.name()) != 0) continue;
                        finished = false;
                        break;
                    }
                    if (finished) {
                        PythonDep dep = this.libraryFacade.getOrCreateDep(this.libraryFacade.getRepo(cc.getChannelUrl(), false), cc.getMachineType(), cc.getInstallType(), cc.getLib(), cc.getVersion(), true, false);
                        Collection<PythonDep> deps = cc.getProjectId().getPythonDepCollection();
                        if (opType.equals((Object)CondaCommandFacade.CondaOp.INSTALL)) {
                            deps.remove(dep);
                            deps.add(dep);
                        } else if (opType.equals((Object)CondaCommandFacade.CondaOp.UNINSTALL)) {
                            deps.remove(dep);
                        }
                        cc.getProjectId().setPythonDepCollection(deps);
                        this.projectFacade.update(cc.getProjectId());
                    }
                }
            } else {
                cc.setStatus(condaStatus);
                cc.setArg(arg);
                this.condaCommandFacade.update(cc);
            }
        } else {
            LOGGER.log(Level.FINE, "Could not remove CondaCommand with id: {0}", commandId);
        }
    }

    public class CondaTask
    implements Runnable {
        private final WebCommunication web;
        private final Project proj;
        private final Hosts host;
        private final CondaCommandFacade.CondaOp op;
        private final PythonDep dep;
        private Object entity;

        public CondaTask(WebCommunication web, Project proj, Hosts host, CondaCommandFacade.CondaOp op, PythonDep dep) {
            this.web = web;
            this.proj = proj;
            this.host = host;
            this.op = op;
            this.dep = dep;
        }

        @Override
        public void run() {
            try {
                this.entity = this.web.conda(this.host.getHostIp(), this.host.getAgentPassword(), this.op.toString(), this.proj.getName(), this.dep.getRepoUrl().getUrl(), this.dep.getDependency(), this.dep.getVersion());
            }
            catch (Exception ex) {
                Logger.getLogger(CondaCommandFacade.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public Object getEntity() {
            return this.entity;
        }
    }

    public class AnacondaTask
    implements Runnable {
        private final WebCommunication web;
        private final String proj;
        private final Hosts host;
        private final CondaCommandFacade.CondaOp op;
        private final String arg;
        private Object entity;

        public AnacondaTask(WebCommunication web, String proj, Hosts host, CondaCommandFacade.CondaOp op, String arg) {
            this.web = web;
            this.proj = proj;
            this.host = host;
            this.op = op;
            this.arg = arg == null ? "" : arg;
        }

        @Override
        public void run() {
            try {
                this.entity = this.web.anaconda(this.host.getHostIp(), this.host.getAgentPassword(), this.op.toString(), this.proj, this.arg);
            }
            catch (Exception ex) {
                Logger.getLogger(CondaCommandFacade.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public Object getEntity() {
            return this.entity;
        }
    }
}

