/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.util.Ip;
import java.util.ArrayList;
import java.util.List;

public class ElasticSettings {
    public static final String ELASTIC_IP_DEFAULT = "127.0.0.1";
    public static final int ELASTIC_PORT_DEFAULT = 9300;
    public static final int ELASTIC_REST_PORT_DEFAULT = 9200;
    public static final boolean ELASTIC_OPENDISTRO_SECURTIY_ENABLED_DEFAULT = false;
    public static final boolean ELASTIC_HTTPS_ENABLED_DEFAULT = false;
    public static final String ELASTIC_ADMIN_USER_DEFAULT = "admin";
    public static final String ELASTIC_ADMIN_PASSWORD_DEFAULT = "adminpw";
    public static final boolean ELASTIC_JWT_ENABLED_DEFAULT = false;
    public static final String ELASTIC_JWT_URL_PARAMETER_DEFAULT = "jt";
    public static final int ELASTIC_JWT_EXP_MS_DEFAULT = 600000;
    public static final String ELASTIC_ADMIN_ROLE = "admin";
    private final List<String> elasticIps;
    private final int elasticPort;
    private final int elasticRestPort;
    private final boolean openDistroEnabled;
    private final boolean httpsEnabled;
    private final String adminUser;
    private final String adminPassword;
    private final boolean elasticJWTEnabled;
    private final String elasticJWTURLParameter;
    private final int elasticJWTExpMs;
    private int rrIndex = 0;

    public ElasticSettings(String elasticIps, int elasticPort, int elasticRestPort, boolean openDistroSecurityEnabled, boolean httpsEnabled, String adminUser, String adminPassword, boolean elasticJWTEnabled, String elasticJWTURLParameter, int elasticJWTExpMs) {
        String[] ips = elasticIps.split(",");
        ArrayList<String> validIps = new ArrayList<String>();
        for (String ip : ips) {
            if (!Ip.validIp(ip)) continue;
            validIps.add(ip);
        }
        this.elasticIps = validIps;
        this.elasticPort = elasticPort;
        this.elasticRestPort = elasticRestPort;
        this.openDistroEnabled = openDistroSecurityEnabled;
        this.httpsEnabled = httpsEnabled;
        this.adminUser = adminUser;
        this.adminPassword = adminPassword;
        this.elasticJWTEnabled = elasticJWTEnabled;
        this.elasticJWTURLParameter = elasticJWTURLParameter;
        this.elasticJWTExpMs = elasticJWTExpMs;
    }

    public List<String> getElasticIps() {
        return this.elasticIps;
    }

    public String getElasticEndpoint() {
        return this.getElasticIp() + ":" + this.elasticPort;
    }

    public String getElasticRESTEndpoint() {
        return (this.isHttpsEnabled() ? "https" : "http") + "://" + this.getElasticIp() + ":" + this.elasticRestPort;
    }

    public int getElasticPort() {
        return this.elasticPort;
    }

    public int getElasticRESTPort() {
        return this.elasticRestPort;
    }

    private String getElasticIp() {
        if (this.rrIndex == this.elasticIps.size()) {
            this.rrIndex = 0;
        }
        return this.elasticIps.get(this.rrIndex++);
    }

    public boolean isOpenDistroSecurityEnabled() {
        return this.openDistroEnabled;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public boolean isElasticJWTEnabled() {
        return this.elasticJWTEnabled;
    }

    public String getElasticJWTURLParameter() {
        return this.elasticJWTURLParameter;
    }

    public int getElasticJWTExpMs() {
        return this.elasticJWTExpMs;
    }
}

