/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.jupyter.PidAndPort;
import java.nio.file.Path;
import java.time.LocalDateTime;

public final class JupyterJWT {
    public final Project project;
    public final Users user;
    public final PidAndPort pidAndPort;
    public final LocalDateTime expiration;
    public Path tokenFile;
    public String token;

    public JupyterJWT(JupyterJWT jupyterJWT) {
        this(jupyterJWT.project, jupyterJWT.user, jupyterJWT.pidAndPort, jupyterJWT.expiration);
        this.tokenFile = jupyterJWT.tokenFile;
    }

    public JupyterJWT(Project project, Users user, PidAndPort pidAndPort, LocalDateTime expiration) {
        this.project = project;
        this.user = user;
        this.pidAndPort = pidAndPort;
        this.expiration = expiration;
    }

    public boolean maybeRenew(LocalDateTime now) {
        return now.isAfter(this.expiration) || now.isEqual(this.expiration);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.project.getId();
        result = 31 * result + this.user.getUid();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JupyterJWT) {
            JupyterJWT other = (JupyterJWT)o;
            return this.user.getUid().equals(other.user.getUid()) && this.project.getId().equals(other.project.getId());
        }
        return false;
    }

    public String toString() {
        return "(" + this.project.getName() + "/" + this.user.getUsername() + ")";
    }
}

