/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.administration;

import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.yarn.YarnClientService;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;

@Stateless
public class JobAdministration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(JobAdministration.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private YarnClientService ycs;
    private Configuration conf;
    private YarnClientWrapper yarnClientWrapper;
    private List<YarnApplicationReport> jobs = new ArrayList<YarnApplicationReport>();
    private List<YarnApplicationReport> filteredJobs = new ArrayList<YarnApplicationReport>();
    private Map<String, String> error = new HashMap<String, String>();
    private boolean initial = true;

    @PostConstruct
    public void init() {
        this.fetchJobs(this.filteredJobs);
    }

    public List<YarnApplicationReport> getAllJobs() {
        if (this.initial) {
            this.jobs.addAll(this.filteredJobs);
            this.initial = false;
        } else {
            this.jobs.clear();
            this.fetchJobs(this.jobs);
        }
        return this.jobs;
    }

    public void setFilteredJobs(List<YarnApplicationReport> filteredJobs) {
        this.filteredJobs = filteredJobs;
    }

    public List<YarnApplicationReport> getFilteredJobs() {
        return this.filteredJobs;
    }

    public String getNumberOfJobs() {
        if (this.yarnClientWrapper == null) {
            this.conf = this.settings.getConfiguration();
            this.yarnClientWrapper = this.ycs.getYarnClientSuper(this.conf);
        }
        try {
            return String.valueOf(this.yarnClientWrapper.getYarnClient().getApplications().size());
        }
        catch (IOException | YarnException ex) {
            Logger.getLogger(JobAdministration.class.getName()).log(Level.SEVERE, null, ex);
            return "N/A";
        }
    }

    public void killJob(String appId) {
        block9: {
            this.error.put(appId, "Trying to kill job");
            if (this.yarnClientWrapper == null) {
                this.conf = this.settings.getConfiguration();
                this.yarnClientWrapper = this.ycs.getYarnClientSuper(this.conf);
            }
            this.error.put(appId, "Application was not found");
            ApplicationId appIdToKill = null;
            try {
                ApplicationReport appReport;
                for (YarnApplicationReport report : this.jobs) {
                    if (!report.getAppId().equals(appId)) continue;
                    appIdToKill = ApplicationId.newInstance((long)report.getClusterTimestamp(), (int)report.getId());
                    appReport = this.yarnClientWrapper.getYarnClient().getApplicationReport(appIdToKill);
                    if (appReport.getYarnApplicationState() == YarnApplicationState.FINISHED || appReport.getYarnApplicationState() == YarnApplicationState.KILLED) {
                        this.error.put(appId, "Job is already " + appReport.getYarnApplicationState());
                        break;
                    }
                    this.yarnClientWrapper.getYarnClient().killApplication(appIdToKill);
                    this.error.put(appId, "Job killed successfully");
                    break;
                }
                this.jobs.clear();
                try {
                    for (ApplicationReport appReport2 : this.yarnClientWrapper.getYarnClient().getApplications()) {
                        this.jobs.add(new YarnApplicationReport(appReport2.getApplicationId().toString(), appReport2.getName(), appReport2.getUser(), appReport2.getStartTime(), appReport2.getFinishTime(), appReport2.getApplicationId().getClusterTimestamp(), appReport2.getApplicationId().getId(), appReport2.getYarnApplicationState().name()));
                    }
                }
                catch (IOException | YarnException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                if (this.filteredJobs == null || appIdToKill == null) break block9;
                ListIterator<YarnApplicationReport> iter = this.filteredJobs.listIterator();
                while (iter.hasNext()) {
                    YarnApplicationReport next = iter.next();
                    if (!next.getAppId().equals(appId)) continue;
                    appReport = this.yarnClientWrapper.getYarnClient().getApplicationReport(appIdToKill);
                    iter.set(new YarnApplicationReport(appReport.getApplicationId().toString(), appReport.getName(), appReport.getUser(), appReport.getStartTime(), appReport.getFinishTime(), appReport.getApplicationId().getClusterTimestamp(), appReport.getApplicationId().getId(), appReport.getYarnApplicationState().name()));
                    break;
                }
            }
            catch (IOException | YarnException ex) {
                logger.log(Level.SEVERE, "Error while trying to kill job with appId:" + appId, ex.getMessage());
            }
        }
    }

    private void fetchJobs(List<YarnApplicationReport> reports) {
        if (this.yarnClientWrapper == null) {
            this.conf = this.settings.getConfiguration();
            this.yarnClientWrapper = this.ycs.getYarnClientSuper(this.conf);
        }
        try {
            for (ApplicationReport appReport : this.yarnClientWrapper.getYarnClient().getApplications()) {
                reports.add(new YarnApplicationReport(appReport.getApplicationId().toString(), appReport.getName(), appReport.getUser(), appReport.getStartTime(), appReport.getFinishTime(), appReport.getApplicationId().getClusterTimestamp(), appReport.getApplicationId().getId(), appReport.getYarnApplicationState().name()));
            }
        }
        catch (IOException | YarnException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    @PreDestroy
    public void preDestroy() {
        if (null != this.yarnClientWrapper) {
            this.ycs.closeYarnClient(this.yarnClientWrapper);
        }
    }

    public String getError(String appId) {
        if (this.error.containsKey(appId)) {
            return this.error.get(appId);
        }
        return null;
    }

    public void setError(Map<String, String> error) {
        this.error = error;
    }

    public class YarnApplicationReport {
        private String appId;
        private String name;
        private String user;
        private Date startTime;
        private Date finishTime;
        private long clusterTimestamp;
        private int id;
        private String state;

        public YarnApplicationReport(String appId, String name, String user, long startTime, long finishTime, long clusterTimestamp, int id, String state) {
            this.appId = appId;
            this.name = name;
            this.user = user;
            this.startTime = new Date(startTime);
            this.finishTime = finishTime == 0L ? null : new Date(finishTime);
            this.clusterTimestamp = clusterTimestamp;
            this.id = id;
            this.state = state;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = new Date(startTime);
        }

        public Date getFinishTime() {
            return this.finishTime;
        }

        public void setFinishTime(long finishTime) {
            this.finishTime = finishTime == 0L ? null : new Date(finishTime);
        }

        public long getClusterTimestamp() {
            return this.clusterTimestamp;
        }

        public void setClusterTimestamp(long clusterTimestamp) {
            this.clusterTimestamp = clusterTimestamp;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public int hashCode() {
            int hash = 5;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            YarnApplicationReport other = (YarnApplicationReport)obj;
            return Objects.equals(this.appId, other.appId);
        }
    }
}

