/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.configuration;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.jobs.beam.BeamFlinkJobConfiguration;
import io.hops.hopsworks.common.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.common.jobs.configuration.JobType;
import io.hops.hopsworks.common.jobs.flink.FlinkJobConfiguration;
import io.hops.hopsworks.common.jobs.spark.SparkJobConfiguration;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.json.JSONObject;

@Converter
public class JobConfigurationConverter
implements AttributeConverter<JobConfiguration, String> {
    private static final Logger LOGGER = Logger.getLogger(JobConfigurationConverter.class.getName());
    private static JAXBContext sparkJAXBContext;
    private static JAXBContext flinkJAXBContext;
    private static JAXBContext beamFlinkJAXBContext;

    public String convertToDatabaseColumn(JobConfiguration config) {
        try {
            JAXBContext jc = this.getJAXBContext(config.getJobType());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("eclipselink.json.include-root", (Object)false);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)config, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public JobConfiguration convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            JSONObject obj = new JSONObject(jsonConfig);
            JobType type = JobType.valueOf((String)obj.get("jobType"));
            JAXBContext jc = this.getJAXBContext(type);
            return this.unmarshal(jsonConfig, type, jc);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private JAXBContext getJAXBContext(JobType jobType) {
        switch (jobType) {
            case SPARK: 
            case PYSPARK: {
                return sparkJAXBContext;
            }
            case FLINK: {
                return flinkJAXBContext;
            }
            case BEAM_FLINK: {
                return beamFlinkJAXBContext;
            }
        }
        throw new IllegalArgumentException("Could not find a mapping for JobType " + (Object)((Object)jobType));
    }

    private JobConfiguration unmarshal(String jsonConfig, JobType jobType, JAXBContext jaxbContext) throws JAXBException {
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StreamSource json = new StreamSource(new StringReader(jsonConfig));
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        switch (jobType) {
            case SPARK: 
            case PYSPARK: {
                return (JobConfiguration)unmarshaller.unmarshal((Source)json, SparkJobConfiguration.class).getValue();
            }
            case FLINK: {
                return (JobConfiguration)unmarshaller.unmarshal((Source)json, FlinkJobConfiguration.class).getValue();
            }
            case BEAM_FLINK: {
                return (JobConfiguration)unmarshaller.unmarshal((Source)json, BeamFlinkJobConfiguration.class).getValue();
            }
        }
        throw new IllegalArgumentException("Could not find a mapping for JobType " + (Object)((Object)jobType));
    }

    static {
        try {
            sparkJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{SparkJobConfiguration.class}, null);
            flinkJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{FlinkJobConfiguration.class}, null);
            beamFlinkJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{BeamFlinkJobConfiguration.class}, null);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "An error occurred while initializing JAXBContext", e);
        }
    }
}

