/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.spark;

import io.hops.hopsworks.common.dao.jobs.description.Jobs;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.common.jobs.spark.SparkJobConfiguration;
import io.hops.hopsworks.common.jobs.spark.SparkYarnRunnerBuilder;
import io.hops.hopsworks.common.jobs.yarn.YarnJob;
import io.hops.hopsworks.common.jobs.yarn.YarnJobsMonitor;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.JobException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.yarn.client.api.YarnClient;

public class SparkJob
extends YarnJob {
    private static final Logger LOG = Logger.getLogger(SparkJob.class.getName());
    private SparkYarnRunnerBuilder runnerbuilder;

    SparkJob(Jobs job, AsynchronousJobExecutor services, Users user, String hadoopDir, String jobUser, YarnJobsMonitor jobsMonitor, Settings settings) {
        super(job, services, user, jobUser, hadoopDir, jobsMonitor, settings);
        if (!(job.getJobConfig() instanceof SparkJobConfiguration)) {
            throw new IllegalArgumentException("JobDescription must contain a SparkJobConfiguration object. Received: " + job.getJobConfig().getClass());
        }
    }

    @Override
    protected boolean setupJob(DistributedFileSystemOps dfso, YarnClient yarnClient) throws JobException {
        super.setupJob(dfso, yarnClient);
        SparkJobConfiguration jobconfig = (SparkJobConfiguration)this.jobs.getJobConfig();
        if (jobconfig.getAppName() == null || jobconfig.getAppName().isEmpty()) {
            jobconfig.setAppName("Untitled Spark Job");
        }
        if (this.runnerbuilder == null) {
            this.runnerbuilder = new SparkYarnRunnerBuilder(this.jobs);
            this.runnerbuilder.setJobName(jobconfig.getAppName());
        }
        this.runnerbuilder.setServiceProps(this.serviceProps);
        if (jobconfig.getLocalResources() != null) {
            this.runnerbuilder.addExtraFiles(Arrays.asList(jobconfig.getLocalResources()));
        }
        this.runnerbuilder.addExtraFiles(this.projectLocalResources);
        if (this.jobSystemProperties != null && !this.jobSystemProperties.isEmpty()) {
            for (Map.Entry jobSystemProperty : this.jobSystemProperties.entrySet()) {
                this.runnerbuilder.addSystemProperty((String)jobSystemProperty.getKey(), (String)jobSystemProperty.getValue());
            }
        }
        String stdOutFinalDestination = Utils.getProjectPath(this.jobs.getProject().getName()) + "Logs/Spark/";
        String stdErrFinalDestination = Utils.getProjectPath(this.jobs.getProject().getName()) + "Logs/Spark/";
        this.setStdOutFinalDestination(stdOutFinalDestination);
        this.setStdErrFinalDestination(stdErrFinalDestination);
        try {
            String firstName = this.user.getFname();
            String lastName = this.user.getLname();
            String usersFullName = null;
            if (firstName != null && !firstName.isEmpty()) {
                usersFullName = firstName;
            }
            if (lastName != null && !lastName.isEmpty()) {
                usersFullName = usersFullName + " " + lastName;
                usersFullName = usersFullName.trim();
            }
            this.runner = this.runnerbuilder.getYarnRunner(this.jobs.getProject(), this.jobUser, usersFullName, this.services, this.services.getFileOperations(this.hdfsUser.getUserName()), yarnClient, this.settings);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to create YarnRunner.", e);
            try {
                this.writeToLogs(e.getLocalizedMessage());
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Failed to write logs for failed application.", ex);
            }
            return false;
        }
        return true;
    }

    @Override
    protected void cleanup() {
        LOG.log(Level.INFO, "Job finished performing cleanup...");
    }
}

