/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.message;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.message.Message;
import io.hops.hopsworks.common.dao.user.Users;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class MessageFacade
extends AbstractFacade<Message> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public MessageFacade() {
        super(Message.class);
    }

    public Message findMessageById(int id) {
        return (Message)this.em.find(Message.class, (Object)id);
    }

    public List<Message> getAllMessagesTo(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.findByToAndDeleted", Message.class).setParameter("to", (Object)user).setParameter("deleted", (Object)false);
        return query.getResultList();
    }

    public List<Message> getAllUnreadMessagesTo(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.findMessagesByToAndUnread", Message.class).setParameter("to", (Object)user).setParameter("unread", (Object)true);
        return query.getResultList();
    }

    public Long countAllMessagesTo(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.countByToAndDeleted", Long.class).setParameter("to", (Object)user).setParameter("deleted", (Object)false);
        try {
            return (Long)query.getSingleResult();
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public Long countUnreadMessagesTo(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.countByToAndUnread", Long.class).setParameter("to", (Object)user).setParameter("unread", (Object)true);
        try {
            return (Long)query.getSingleResult();
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<Message> getAllDeletedMessagesTo(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.findByToAndDeleted", Message.class).setParameter("to", (Object)user).setParameter("deleted", (Object)true);
        return query.getResultList();
    }

    public Long countDeletedMessagesTo(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.countByToAndDeleted", Long.class).setParameter("to", (Object)user).setParameter("deleted", (Object)true);
        try {
            return (Long)query.getSingleResult();
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public int emptyTrash(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.emptyToAndDeleted", Long.class).setParameter("to", (Object)user).setParameter("deleted", (Object)true);
        try {
            return query.executeUpdate();
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public int emptyMessage(Users user) {
        TypedQuery query = this.em.createNamedQuery("Message.emptyToAndDeleted", Long.class).setParameter("to", (Object)user).setParameter("deleted", (Object)false);
        try {
            return query.executeUpdate();
        }
        catch (NoResultException e) {
            return 0;
        }
    }
}

