/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.external.ExternalTrainingDataset;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.hopsfs.HopsfsTrainingDataset;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dao.jobs.description.Jobs;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.feature.FeaturestoreFeatureController;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobController;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobDTO;
import io.hops.hopsworks.common.featurestore.statistics.FeaturestoreStatisticController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.StringUtils;

@Stateless
public class TrainingDatasetController {
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturestoreStatisticController featurestoreStatisticController;
    @EJB
    private FeaturestoreFeatureController featurestoreFeatureController;
    @EJB
    private JobFacade jobFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private HopsfsTrainingDatasetController hopsfsTrainingDatasetController;
    @EJB
    private ExternalTrainingDatasetController externalTrainingDatasetController;
    @EJB
    private FeaturestoreJobController featurestoreJobController;
    @EJB
    private FeaturestoreInputValidation featurestoreInputValidation;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<TrainingDatasetDTO> getTrainingDatasetsForFeaturestore(Featurestore featurestore) {
        List<TrainingDataset> trainingDatasets = this.trainingDatasetFacade.findByFeaturestore(featurestore);
        return trainingDatasets.stream().map(td -> this.convertTrainingDatasetToDTO((TrainingDataset)td)).collect(Collectors.toList());
    }

    private TrainingDatasetDTO convertTrainingDatasetToDTO(TrainingDataset trainingDataset) {
        String featurestoreName = this.featurestoreFacade.getHiveDbName(trainingDataset.getFeaturestore().getHiveDbId());
        switch (trainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO = this.hopsfsTrainingDatasetController.convertHopsfsTrainingDatasetToDTO(trainingDataset);
                hopsfsTrainingDatasetDTO.setFeaturestoreName(featurestoreName);
                return hopsfsTrainingDatasetDTO;
            }
            case EXTERNAL_TRAINING_DATASET: {
                ExternalTrainingDatasetDTO externalTrainingDatasetDTO = this.externalTrainingDatasetController.convertExternalTrainingDatasetToDTO(trainingDataset);
                externalTrainingDatasetDTO.setFeaturestoreName(featurestoreName);
                return externalTrainingDatasetDTO;
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE.getMessage() + ", Recognized training dataset types are: " + (Object)((Object)TrainingDatasetType.HOPSFS_TRAINING_DATASET) + ", and: " + (Object)((Object)TrainingDatasetType.EXTERNAL_TRAINING_DATASET) + ". The provided training dataset type was not recognized: " + (Object)((Object)trainingDataset.getTrainingDatasetType()));
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public TrainingDatasetDTO createTrainingDataset(Users user, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException {
        this.featurestoreInputValidation.verifyUserInput(trainingDatasetDTO);
        this.verifyTrainingDatasetInput(trainingDatasetDTO, featurestore);
        this.verifyStatisticsInput(trainingDatasetDTO);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(featurestore.getProject(), user);
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        HopsfsTrainingDataset hopsfsTrainingDataset = null;
        ExternalTrainingDataset externalTrainingDataset = null;
        switch (trainingDatasetDTO.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                hopsfsTrainingDataset = this.hopsfsTrainingDatasetController.createHopsfsTrainingDataset((HopsfsTrainingDatasetDTO)trainingDatasetDTO);
                break;
            }
            case EXTERNAL_TRAINING_DATASET: {
                this.removeExternalTrainingDatasetIfExists(featurestore, trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
                externalTrainingDataset = this.externalTrainingDatasetController.createExternalTrainingDataset((ExternalTrainingDatasetDTO)trainingDatasetDTO);
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE, Level.FINE, ", Recognized training dataset types are: " + (Object)((Object)TrainingDatasetType.HOPSFS_TRAINING_DATASET) + ", and: " + (Object)((Object)TrainingDatasetType.EXTERNAL_TRAINING_DATASET) + ". The provided training dataset type was not recognized: " + (Object)((Object)trainingDatasetDTO.getTrainingDatasetType()));
            }
        }
        TrainingDataset trainingDataset = new TrainingDataset();
        trainingDataset.setHopsfsTrainingDataset(hopsfsTrainingDataset);
        trainingDataset.setExternalTrainingDataset(externalTrainingDataset);
        trainingDataset.setDataFormat(trainingDatasetDTO.getDataFormat());
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        trainingDataset.setFeaturestore(featurestore);
        trainingDataset.setHdfsUserId(hdfsUser.getId());
        trainingDataset.setCreated(new Date());
        trainingDataset.setCreator(user);
        trainingDataset.setVersion(trainingDatasetDTO.getVersion());
        trainingDataset.setTrainingDatasetType(trainingDatasetDTO.getTrainingDatasetType());
        this.trainingDatasetFacade.persist(trainingDataset);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(null, trainingDataset, trainingDatasetDTO.getFeatureCorrelationMatrix(), trainingDatasetDTO.getDescriptiveStatistics(), trainingDatasetDTO.getFeaturesHistogram(), trainingDatasetDTO.getClusterAnalysis());
        this.featurestoreFeatureController.updateTrainingDatasetFeatures(trainingDataset, trainingDatasetDTO.getFeatures());
        List<Jobs> jobs = this.getJobs(trainingDatasetDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobController.insertJobs(trainingDataset, jobs);
        return this.convertTrainingDatasetToDTO(trainingDataset);
    }

    private List<Jobs> getJobs(List<FeaturestoreJobDTO> jobDTOs, Project project) {
        if (jobDTOs != null) {
            return jobDTOs.stream().filter(jobDTO -> jobDTO != null && !Strings.isNullOrEmpty((String)jobDTO.getJobName())).map(jobDTO -> jobDTO.getJobName()).distinct().map(jobName -> this.jobFacade.findByProjectAndName(project, (String)jobName)).collect(Collectors.toList());
        }
        return new ArrayList<Jobs>();
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public TrainingDatasetDTO getTrainingDatasetWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(id, featurestore);
        if (trainingDataset == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "trainingDatasetId: " + id);
        }
        return this.convertTrainingDatasetToDTO(trainingDataset);
    }

    public Inode getInodeWithTrainingDatasetIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(id, featurestore);
        if (trainingDataset == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "trainingDatasetId: " + id);
        }
        if (trainingDataset.getTrainingDatasetType() != TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CAN_ONLY_GET_INODE_FOR_HOPSFS_TRAINING_DATASETS, Level.FINE, "Training Dataset Type: " + (Object)((Object)trainingDataset.getTrainingDatasetType()));
        }
        return trainingDataset.getHopsfsTrainingDataset().getInode();
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public TrainingDatasetDTO getTrainingDatasetByFeaturestoreAndName(Project project, Featurestore featurestore, String trainingDatasetName, int version) throws FeaturestoreException {
        List<TrainingDataset> trainingDatasets = this.trainingDatasetFacade.findByFeaturestore(featurestore);
        List trainingDatasetDTOS = trainingDatasets.stream().map(td -> this.convertTrainingDatasetToDTO((TrainingDataset)td)).collect(Collectors.toList());
        List trainingDatasetsDTOWithName = trainingDatasetDTOS.stream().filter(td -> td.getName().equals(trainingDatasetName) && td.getVersion() == version).collect(Collectors.toList());
        if (trainingDatasetsDTOWithName.size() != 1) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "featurestoreId: " + featurestore.getId() + " , project: " + project.getName() + " trainingDatasetName: " + trainingDatasetName);
        }
        return (TrainingDatasetDTO)trainingDatasetsDTOWithName.get(0);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public TrainingDatasetDTO deleteTrainingDatasetWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(id, featurestore);
        TrainingDatasetDTO trainingDatasetDTO = this.convertTrainingDatasetToDTO(trainingDataset);
        switch (trainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                this.hopsfsTrainingDatasetController.removeHopsfsTrainingDataset(trainingDataset.getHopsfsTrainingDataset());
                break;
            }
            case EXTERNAL_TRAINING_DATASET: {
                this.externalTrainingDatasetController.removeExternalTrainingDataset(trainingDataset.getExternalTrainingDataset());
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE, Level.FINE, ", Recognized training dataset types are: " + (Object)((Object)TrainingDatasetType.HOPSFS_TRAINING_DATASET) + ", and: " + (Object)((Object)TrainingDatasetType.EXTERNAL_TRAINING_DATASET) + ". The provided training dataset type was not recognized: " + (Object)((Object)trainingDataset.getTrainingDatasetType()));
            }
        }
        return trainingDatasetDTO;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public TrainingDatasetDTO updateTrainingDatasetMetadata(Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.verifyTrainingDatasetId(trainingDatasetDTO.getId(), featurestore);
        this.featurestoreInputValidation.verifyUserInput(trainingDatasetDTO);
        this.verifyTrainingDatasetDataFormat(trainingDatasetDTO.getDataFormat());
        List<Jobs> jobs = this.getJobs(trainingDatasetDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobController.insertJobs(trainingDataset, jobs);
        trainingDataset.setDataFormat(trainingDataset.getDataFormat());
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        TrainingDataset updatedTrainingDataset = this.trainingDatasetFacade.updateTrainingDatasetMetadata(trainingDataset);
        this.featurestoreFeatureController.updateTrainingDatasetFeatures(trainingDataset, trainingDatasetDTO.getFeatures());
        switch (updatedTrainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                this.hopsfsTrainingDatasetController.updateHopsfsTrainingDatasetMetadata(trainingDataset.getHopsfsTrainingDataset(), (HopsfsTrainingDatasetDTO)trainingDatasetDTO);
                break;
            }
            case EXTERNAL_TRAINING_DATASET: {
                this.externalTrainingDatasetController.updateExternalTrainingDatasetMetadata(trainingDataset.getExternalTrainingDataset(), (ExternalTrainingDatasetDTO)trainingDatasetDTO);
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE, Level.FINE, ", Recognized training dataset types are: " + (Object)((Object)TrainingDatasetType.HOPSFS_TRAINING_DATASET) + ", and: " + (Object)((Object)TrainingDatasetType.EXTERNAL_TRAINING_DATASET) + ". The provided training dataset type was not recognized: " + (Object)((Object)trainingDatasetDTO.getTrainingDatasetType()));
            }
        }
        return this.convertTrainingDatasetToDTO(updatedTrainingDataset);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public TrainingDatasetDTO updateTrainingDatasetStats(Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) {
        TrainingDataset trainingDataset = this.verifyTrainingDatasetId(trainingDatasetDTO.getId(), featurestore);
        this.verifyStatisticsInput(trainingDatasetDTO);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(null, trainingDataset, trainingDatasetDTO.getFeatureCorrelationMatrix(), trainingDatasetDTO.getDescriptiveStatistics(), trainingDatasetDTO.getFeaturesHistogram(), trainingDatasetDTO.getClusterAnalysis());
        return this.convertTrainingDatasetToDTO(trainingDataset);
    }

    public Dataset getTrainingDatasetFolder(Project project) {
        return this.datasetController.getByProjectAndDsName(project, null, this.getTrainingDatasetFolderName(project));
    }

    public String getTrainingDatasetFolderName(Project project) {
        return project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
    }

    public String getTrainingDatasetPath(String trainingDatasetsFolderPath, String trainingDatasetName, Integer version) {
        return trainingDatasetsFolderPath + "/" + trainingDatasetName + "_" + version;
    }

    private void verifyStatisticsInput(TrainingDatasetDTO trainingDatasetDTO) {
        if (trainingDatasetDTO.getFeatureCorrelationMatrix() != null && trainingDatasetDTO.getFeatureCorrelationMatrix().getFeatureCorrelations().size() > 50) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.CORRELATION_MATRIX_EXCEED_MAX_SIZE.getMessage());
        }
    }

    private TrainingDataset verifyTrainingDatasetId(Integer trainingDatasetId, Featurestore featurestore) {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetId, featurestore);
        if (trainingDataset == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND + ", training dataset id: " + trainingDatasetId);
        }
        return trainingDataset;
    }

    private void verifyTrainingDatasetType(TrainingDatasetType trainingDatasetType) throws FeaturestoreException {
        if (trainingDatasetType != TrainingDatasetType.HOPSFS_TRAINING_DATASET && trainingDatasetType != TrainingDatasetType.EXTERNAL_TRAINING_DATASET) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE, Level.FINE, ", Recognized Training Dataset types are: " + (Object)((Object)TrainingDatasetType.HOPSFS_TRAINING_DATASET) + ", and: " + (Object)((Object)TrainingDatasetType.EXTERNAL_TRAINING_DATASET) + ". The provided training dataset type was not recognized: " + (Object)((Object)trainingDatasetType));
        }
    }

    private void verifyTrainingDatasetVersion(Integer version) throws FeaturestoreException {
        if (version == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_VERSION_NOT_PROVIDED.getMessage());
        }
        if (version <= 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_VERSION, Level.FINE, " version cannot be negative or zero");
        }
    }

    private void verifyTrainingDatasetDataFormat(String dataFormat) throws FeaturestoreException {
        if (!FeaturestoreConstants.TRAINING_DATASET_DATA_FORMATS.contains(dataFormat)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_DATA_FORMAT, Level.FINE, ", the recognized training dataset formats are: " + StringUtils.join((Object[])new List[]{FeaturestoreConstants.TRAINING_DATASET_DATA_FORMATS}) + ". The provided data format:" + dataFormat + " was not recognized.");
        }
    }

    private void verifyTrainingDatasetInput(TrainingDatasetDTO trainingDatasetDTO, Featurestore featurestore) throws FeaturestoreException {
        this.verifyTrainingDatasetType(trainingDatasetDTO.getTrainingDatasetType());
        this.verifyTrainingDatasetVersion(trainingDatasetDTO.getVersion());
        this.verifyTrainingDatasetDataFormat(trainingDatasetDTO.getDataFormat());
    }

    private void removeExternalTrainingDatasetIfExists(Featurestore featurestore, String externalTrainingDatasetName, Integer externalTrainingDatasetVersion) {
        List<TrainingDataset> trainingDatasets = this.trainingDatasetFacade.findByFeaturestore(featurestore);
        trainingDatasets.stream().filter(td -> td.getTrainingDatasetType() == TrainingDatasetType.EXTERNAL_TRAINING_DATASET && td.getExternalTrainingDataset().getName().equals(externalTrainingDatasetName) && td.getVersion().equals(externalTrainingDatasetVersion)).collect(Collectors.toList());
        trainingDatasets.forEach(td -> this.externalTrainingDatasetController.removeExternalTrainingDataset(td.getExternalTrainingDataset()));
    }
}

