/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.dto.ProvCoreDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvDatasetDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvFeatureDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.util.HopsworksJAXBContext;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless(name="HopsFSProvenanceController")
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class HopsFSProvenanceController {
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;
    @EJB
    private HopsworksJAXBContext converter;

    private ProvCoreDTO getProvCoreXAttr(String path, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            byte[] provTypeB = udfso.getXAttr(path, "provenance.core");
            if (provTypeB == null) {
                return null;
            }
            return this.converter.unmarshal(new String(provTypeB), ProvCoreDTO.class);
        }
        catch (GenericException | IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - get xattr - prov core - error", "hopsfs - get xattr - prov core - error", e);
        }
    }

    private void setProvCoreXAttr(String path, ProvCoreDTO provCore, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            String provType = this.converter.marshal(provCore);
            udfso.upsertXAttr(path, "provenance.core", provType.getBytes());
        }
        catch (GenericException | IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - prov core - error", "hopsfs - set xattr - prov core - error", e);
        }
    }

    private void setFeaturesXAttr(String path, List<FeatureDTO> features, DistributedFileSystemOps udfso) throws ProvenanceException {
        if (features == null) {
            return;
        }
        List<ProvFeatureDTO> featuresDTO = this.fromFeatures(features);
        try {
            udfso.upsertXAttr(path, "provenance.features", this.converter.marshal(featuresDTO).getBytes());
        }
        catch (GenericException | IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - prov features - error", "hopsfs - set xattr - prov features - error", e);
        }
    }

    private void setFeaturesXAttr(String path, FeaturegroupDTO featuregroup, DistributedFileSystemOps udfso) throws ProvenanceException {
        List<ProvFeatureDTO> featuresDTO = this.fromFeatures(featuregroup);
        try {
            udfso.upsertXAttr(path, "provenance.features", this.converter.marshal(featuresDTO).getBytes());
        }
        catch (GenericException | IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - prov features - error", "hopsfs - set xattr - prov features - error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvCoreDTO getDatasetProvCore(Users user, Dataset dataset) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(dataset.getProject(), user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
        try {
            ProvCoreDTO provCoreDTO = this.getProvCoreXAttr(datasetPath, udfso);
            return provCoreDTO;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvTypeDTO getProjectProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        String projectPath = Utils.getProjectPath(project.getName());
        try {
            ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, udfso);
            ProvTypeDTO provTypeDTO = provCore == null ? null : provCore.getType();
            return provTypeDTO;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectProvType(Users user, Project project, ProvTypeDTO provType) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            this.updateProjectProvType(project, provType, udfso);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void updateProjectProvType(Project project, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        String projectPath = Utils.getProjectPath(project.getName());
        ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, dfso);
        if (provCore != null && newProvType.equals(provCore.getType())) {
            return;
        }
        provCore = new ProvCoreDTO(newProvType, null);
        this.setProvCoreXAttr(projectPath, provCore, dfso);
        provCore = new ProvCoreDTO(newProvType, project.getInode().getId());
        for (Dataset dataset : project.getDatasetCollection()) {
            String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
            ProvCoreDTO datasetProvCore = this.getProvCoreXAttr(datasetPath, dfso);
            if (datasetProvCore != null && (datasetProvCore.getType().equals(Provenance.Type.DISABLED.dto) || datasetProvCore.getType().equals(newProvType))) continue;
            this.updateDatasetProvType(datasetPath, provCore, dfso);
        }
    }

    public void updateDatasetProvType(Dataset dataset, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        ProvCoreDTO newProvCore = new ProvCoreDTO(newProvType, dataset.getProject().getInode().getId());
        String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
        ProvCoreDTO currentProvCore = this.getProvCoreXAttr(datasetPath, dfso);
        if (currentProvCore != null && currentProvCore.getType().equals(newProvType)) {
            return;
        }
        this.updateDatasetProvType(datasetPath, newProvCore, dfso);
    }

    public void newHiveDatasetProvCore(Project project, String hiveDBPath, DistributedFileSystemOps dfso) throws ProvenanceException {
        String projectPath = Utils.getProjectPath(project.getName());
        ProvCoreDTO projectProvCore = this.getProvCoreXAttr(projectPath, dfso);
        if (projectProvCore == null) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "hopsfs - hive db - set meta status error - project without prov core");
        }
        ProvCoreDTO datasetProvCore = new ProvCoreDTO(projectProvCore.getType(), project.getInode().getId());
        this.updateDatasetProvType(hiveDBPath, datasetProvCore, dfso);
    }

    private void updateDatasetProvType(String datasetPath, ProvCoreDTO provCore, DistributedFileSystemOps dfso) throws ProvenanceException {
        try {
            dfso.setMetaStatus(datasetPath, provCore.getType().getMetaStatus());
        }
        catch (IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - dataset set meta status error", "hopsfs - dataset set meta status error", (Throwable)e);
        }
        this.setProvCoreXAttr(datasetPath, provCore, dfso);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvDatasetDTO> getDatasetsProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        try (DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);){
            ArrayList<ProvDatasetDTO> result = new ArrayList<ProvDatasetDTO>();
            for (Dataset dataset : project.getDatasetCollection()) {
                String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
                ProvCoreDTO provCore = this.getProvCoreXAttr(datasetPath, udfso);
                ProvDatasetDTO dsState = new ProvDatasetDTO(dataset.getName(), dataset.getInode().getId(), provCore.getType());
                result.add(dsState);
            }
            ArrayList<ProvDatasetDTO> arrayList = result;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void featuregroupAttachXAttrs(Users user, Project project, FeaturegroupDTO featuregroup) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            String featuregroupPath = Utils.getFeaturestorePath(project, this.settings) + "/" + Utils.getFeaturegroupName(featuregroup.getName(), featuregroup.getVersion());
            this.setFeaturesXAttr(featuregroupPath, featuregroup, udfso);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trainingDatasetAttachXAttr(Users user, Project project, String path, List<FeatureDTO> features) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            this.setFeaturesXAttr(path, features, udfso);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    private List<ProvFeatureDTO> fromFeatures(List<FeatureDTO> features) {
        LinkedList<ProvFeatureDTO> result = new LinkedList<ProvFeatureDTO>();
        for (FeatureDTO feature : features) {
            result.add(new ProvFeatureDTO(feature.getFeaturegroup(), feature.getName(), feature.getVersion()));
        }
        return result;
    }

    private List<ProvFeatureDTO> fromFeatures(FeaturegroupDTO featuregroup) {
        LinkedList<ProvFeatureDTO> result = new LinkedList<ProvFeatureDTO>();
        for (FeatureDTO feature : featuregroup.getFeatures()) {
            result.add(new ProvFeatureDTO(featuregroup.getName(), feature.getName(), featuregroup.getVersion()));
        }
        return result;
    }
}

