/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobs.quota;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.jobs.quota.YarnPriceMultiplicator;
import io.hops.hopsworks.common.dao.jobs.quota.YarnProjectsQuota;
import io.hops.metadata.yarn.entity.quota.PriceMultiplicator;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class YarnProjectsQuotaFacade
extends AbstractFacade<YarnProjectsQuota> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void persistYarnProjectsQuota(YarnProjectsQuota yarnProjectsQuota) {
        this.em.persist((Object)yarnProjectsQuota);
    }

    public YarnProjectsQuotaFacade() {
        super(YarnProjectsQuota.class);
    }

    public YarnProjectsQuota findByProjectName(String projectname) {
        TypedQuery query = this.em.createNamedQuery("YarnProjectsQuota.findByProjectname", YarnProjectsQuota.class).setParameter("projectname", (Object)projectname);
        try {
            return (YarnProjectsQuota)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void flushEm() {
        this.em.flush();
    }

    @Override
    public List<YarnProjectsQuota> findAll() {
        TypedQuery query = this.em.createNamedQuery("YarnProjectsQuota.findAll", YarnProjectsQuota.class);
        return query.getResultList();
    }

    public void changeYarnQuota(String projectName, float quota) {
        YarnProjectsQuota project = this.findByProjectName(projectName);
        if (project != null) {
            project.setQuotaRemaining(quota);
            this.em.merge((Object)project);
        }
    }

    public YarnPriceMultiplicator getMultiplicator(PriceMultiplicator.MultiplicatorType multiplicatorType) {
        try {
            TypedQuery query = this.em.createNamedQuery("YarnPriceMultiplicator.findById", YarnPriceMultiplicator.class).setParameter("id", (Object)multiplicatorType.name());
            return (YarnPriceMultiplicator)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<YarnPriceMultiplicator> getMultiplicators() {
        try {
            TypedQuery query = this.em.createNamedQuery("YarnPriceMultiplicator.findAll", YarnPriceMultiplicator.class);
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<YarnPriceMultiplicator>();
        }
    }
}

