/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.project.team;

import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.service.ProjectServiceFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectRoleTypes;
import io.hops.hopsworks.common.dao.project.team.ProjectTeam;
import io.hops.hopsworks.common.dao.user.Users;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class ProjectTeamFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private ProjectServiceFacade projectServiceFacade;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public int countProjectTeam(Project project, String role) {
        TypedQuery query = this.em.createNamedQuery("ProjectTeam.countMembersForProjectAndRole", Long.class);
        query.setParameter("project", (Object)project);
        query.setParameter("teamRole", (Object)role);
        return ((Long)query.getSingleResult()).intValue();
    }

    public int countMembersInProject(Project project) {
        TypedQuery query = this.em.createNamedQuery("ProjectTeam.countAllMembersForProject", Long.class);
        query.setParameter("project", (Object)project);
        return ((Long)query.getSingleResult()).intValue();
    }

    public List<Users> findTeamMembersByProject(Project project, String role) {
        List<ProjectTeam> results = this.findProjectTeamByProjectAndRole(project, role);
        ArrayList<Users> retList = new ArrayList<Users>(results.size());
        for (ProjectTeam st : results) {
            retList.add(st.getUser());
        }
        return retList;
    }

    public List<ProjectTeam> findProjectTeamByProjectAndRole(Project project, String role) {
        TypedQuery q = this.em.createNamedQuery("ProjectTeam.findMembersByRoleInProject", ProjectTeam.class);
        q.setParameter("project", (Object)project);
        q.setParameter("teamRole", (Object)role);
        return q.getResultList();
    }

    public List<ProjectTeam> findResearchMembersByName(Project project) {
        return this.findProjectTeamByProjectAndRole(project, "Researcher");
    }

    public List<ProjectTeam> findGuestMembersByName(Project project) {
        return this.findProjectTeamByProjectAndRole(project, "Guest");
    }

    public List<ProjectTeam> findMembersByProject(Project project) {
        TypedQuery query = this.em.createNamedQuery("ProjectTeam.findByProject", ProjectTeam.class);
        query.setParameter("project", (Object)project);
        return query.getResultList();
    }

    public List<ProjectTeam> findActiveByMember(Users member) {
        TypedQuery query = this.em.createNamedQuery("ProjectTeam.findActiveByTeamMember", ProjectTeam.class).setParameter("user", (Object)member);
        return query.getResultList();
    }

    public int countByMember(Users user) {
        TypedQuery query = this.em.createNamedQuery("ProjectTeam.countStudiesByMember", Long.class);
        query.setParameter("user", (Object)user);
        return ((Long)query.getSingleResult()).intValue();
    }

    public int countByMemberEmail(String email) {
        TypedQuery query = this.em.createNamedQuery("Users.findByEmail", Users.class);
        query.setParameter("email", (Object)email);
        Users user = (Users)query.getSingleResult();
        return this.countByMember(user);
    }

    public String findCurrentRole(Project project, Users user) {
        TypedQuery q = this.em.createNamedQuery("ProjectTeam.findRoleForUserInProject", ProjectTeam.class);
        q.setParameter("project", (Object)project);
        q.setParameter("user", (Object)user);
        try {
            return ((ProjectTeam)q.getSingleResult()).getTeamRole();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String findCurrentRole(Project project, String user) {
        TypedQuery q = this.em.createNamedQuery("Users.findByEmail", Users.class);
        q.setParameter("email", (Object)user);
        try {
            Users u = (Users)q.getSingleResult();
            return this.findCurrentRole(project, u);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void persistProjectTeam(ProjectTeam team) {
        this.em.persist((Object)team);
    }

    public void update(ProjectTeam team) {
        if (team != null) {
            this.em.merge((Object)team);
        }
    }

    public void removeProjectTeam(Project project, Users user) {
        ProjectTeam team = this.findByPrimaryKey(project, user);
        if (team != null) {
            this.em.remove((Object)team);
        }
    }

    public void removeProjectTeam(Project project, String email) {
        TypedQuery query = this.em.createNamedQuery("Users.findByEmail", Users.class);
        query.setParameter("email", (Object)email);
        this.removeProjectTeam(project, (Users)query.getSingleResult());
    }

    public void updateTeamRole(Project project, Users user, String teamRole) {
        ProjectTeam team = this.findByPrimaryKey(project, user);
        if (team != null) {
            team.setTeamRole(teamRole);
            team.setTimestamp(new Date());
            this.em.merge((Object)team);
        }
    }

    public void updateTeamRole(Project project, String email, String teamRole) {
        TypedQuery query = this.em.createNamedQuery("Users.findByEmail", Users.class);
        query.setParameter("email", (Object)email);
        this.updateTeamRole(project, (Users)query.getSingleResult(), teamRole);
    }

    public List<ProjectTeam> updateTeamRole(Project project, ProjectRoleTypes teamRole) {
        List<ProjectTeam> teamMembers = this.findMembersByProject(project);
        for (ProjectTeam member : teamMembers) {
            member.setTeamRole(teamRole.getRole());
            member.setTimestamp(new Date());
            this.em.merge((Object)member);
        }
        return teamMembers;
    }

    public ProjectTeam findByPrimaryKey(Project project, Users user) {
        return (ProjectTeam)this.em.find(ProjectTeam.class, (Object)new ProjectTeam(project, user).getProjectTeamPK());
    }

    public boolean isUserMemberOfProject(Project project, Users user) {
        TypedQuery q = this.em.createNamedQuery("ProjectTeam.findRoleForUserInProject", ProjectTeam.class);
        q.setParameter("project", (Object)project);
        q.setParameter("user", (Object)user);
        return q.getResultList().size() > 0;
    }

    public boolean isUserMemberOfProject(Project project, String user) {
        TypedQuery q = this.em.createNamedQuery("Users.findByEmail", Users.class);
        q.setParameter("email", (Object)user);
        return this.isUserMemberOfProject(project, (Users)q.getSingleResult());
    }

    public ProjectTeam findProjectTeam(Project project, Users user) {
        TypedQuery q = this.em.createNamedQuery("ProjectTeam.findRoleForUserInProject", ProjectTeam.class);
        q.setParameter("user", (Object)user);
        q.setParameter("project", (Object)project);
        try {
            return (ProjectTeam)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Users findUserByEmail(String userEmail) {
        TypedQuery q = this.em.createNamedQuery("Users.findByEmail", Users.class);
        q.setParameter("email", (Object)userEmail);
        try {
            return (Users)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

