/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.python;

import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="conda_commands", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="CondaCommands.findAll", query="SELECT c FROM CondaCommands c"), @NamedQuery(name="CondaCommands.findById", query="SELECT c FROM CondaCommands c WHERE c.id = :id"), @NamedQuery(name="CondaCommands.findByUser", query="SELECT c FROM CondaCommands c WHERE c.user = :user"), @NamedQuery(name="CondaCommands.findByOp", query="SELECT c FROM CondaCommands c WHERE c.op = :op"), @NamedQuery(name="CondaCommands.findByProj", query="SELECT c FROM CondaCommands c WHERE c.projectId = :projectId"), @NamedQuery(name="CondaCommands.findByProjectAndStatus", query="SELECT c FROM CondaCommands c WHERE c.projectId = :projectId AND c.status = :status"), @NamedQuery(name="CondaCommands.findByProjectAndLibAndStatus", query="SELECT c FROM CondaCommands c WHERE c.projectId = :projectId AND c.lib = :lib AND c.status = :status"), @NamedQuery(name="CondaCommands.findByChannelUrl", query="SELECT c FROM CondaCommands c WHERE c.channelUrl = :channelUrl"), @NamedQuery(name="CondaCommands.findByArg", query="SELECT c FROM CondaCommands c WHERE c.arg = :arg"), @NamedQuery(name="CondaCommands.findByLib", query="SELECT c FROM CondaCommands c WHERE c.lib = :lib"), @NamedQuery(name="CondaCommands.findByVersion", query="SELECT c FROM CondaCommands c WHERE c.version = :version"), @NamedQuery(name="CondaCommands.findByStatus", query="SELECT c FROM CondaCommands c WHERE c.status = :status"), @NamedQuery(name="CondaCommands.findByCreated", query="SELECT c FROM CondaCommands c WHERE c.created = :created"), @NamedQuery(name="CondaCommands.deleteAllFailedCommands", query="DELETE FROM CondaCommands c WHERE c.status = :status"), @NamedQuery(name="CondaCommands.findByHost", query="SELECT c FROM CondaCommands c WHERE c.hostId = :host"), @NamedQuery(name="CondaCommands.findNotFinishedByHost", query="SELECT c FROM CondaCommands c WHERE c.hostId = :host AND c.status != io.hops.hopsworks.common.dao.python.CondaCommandFacade.CondaStatus.SUCCESS AND c.status != io.hops.hopsworks.common.dao.python.CondaCommandFacade.CondaStatus.FAILED")})
public class CondaCommands
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="user")
    private String user;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="proj")
    private String proj;
    @Size(max=255)
    @Column(name="channel_url")
    private String channelUrl;
    @Size(max=255)
    @Column(name="arg")
    private String arg = "";
    @Size(max=255)
    @Column(name="lib")
    private String lib = "";
    @Size(max=52)
    @Column(name="version")
    private String version = "";
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="op")
    @Enumerated(value=EnumType.STRING)
    private CondaCommandFacade.CondaOp op;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private CondaCommandFacade.CondaStatus status;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="install_type")
    @Enumerated(value=EnumType.STRING)
    private CondaCommandFacade.CondaInstallType installType;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=52)
    @Column(name="machine_type")
    @Enumerated(value=EnumType.STRING)
    private LibraryFacade.MachineType machineType;
    @Basic(optional=false)
    @NotNull
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project projectId;
    @JoinColumn(name="host_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Hosts hostId;
    @Size(min=1, max=10000)
    @Column(name="environment_yml")
    private String environmentYml;
    @Column(name="install_jupyter")
    private Boolean installJupyter = false;

    public CondaCommands() {
    }

    public CondaCommands(Hosts h, String user, CondaCommandFacade.CondaOp op, CondaCommandFacade.CondaStatus status, CondaCommandFacade.CondaInstallType installType, LibraryFacade.MachineType machineType, Project project, String lib, String version, String channelUrl, Date created, String arg, String environmentYml, Boolean installJupyter) {
        this.hostId = h;
        if (op == null || user == null || project == null) {
            throw new NullPointerException("Op/user/project cannot be null");
        }
        this.user = user;
        this.op = op;
        this.proj = project.getName();
        this.projectId = project;
        this.status = status;
        this.installType = installType;
        this.machineType = machineType;
        this.created = created;
        this.channelUrl = channelUrl;
        this.lib = lib;
        this.version = version;
        this.arg = arg;
        this.environmentYml = environmentYml;
        this.installJupyter = installJupyter;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getProj() {
        return this.proj;
    }

    public void setProj(String proj) {
        this.proj = proj;
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public void setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
    }

    public String getArg() {
        return this.arg;
    }

    public void setArg(String arg) {
        this.arg = arg;
    }

    public String getLib() {
        return this.lib;
    }

    public void setLib(String lib) {
        this.lib = lib;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Project getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Project projectId) {
        this.projectId = projectId;
    }

    public Hosts getHostId() {
        return this.hostId;
    }

    public void setHostId(Hosts hostId) {
        this.hostId = hostId;
    }

    public CondaCommandFacade.CondaOp getOp() {
        return this.op;
    }

    public void setOp(CondaCommandFacade.CondaOp op) {
        this.op = op;
    }

    public CondaCommandFacade.CondaStatus getStatus() {
        return this.status;
    }

    public void setStatus(CondaCommandFacade.CondaStatus status) {
        this.status = status;
    }

    public CondaCommandFacade.CondaInstallType getInstallType() {
        return this.installType;
    }

    public void setInstallType(CondaCommandFacade.CondaInstallType installType) {
        this.installType = installType;
    }

    public LibraryFacade.MachineType getMachineType() {
        return this.machineType;
    }

    public void setMachineType(LibraryFacade.MachineType machineType) {
        this.machineType = machineType;
    }

    public String getEnvironmentYml() {
        return this.environmentYml;
    }

    public void setEnvironmentYml(String environmentYml) {
        this.environmentYml = environmentYml;
    }

    public Boolean getInstallJupyter() {
        return this.installJupyter;
    }

    public void setInstallJupyter(Boolean installJupyter) {
        this.installJupyter = installJupyter;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CondaCommands)) {
            return false;
        }
        CondaCommands other = (CondaCommands)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "[ id=" + this.id + ", proj=" + this.proj + ", op=" + (Object)((Object)this.op) + ", installType=" + (Object)((Object)this.installType) + ", hostType=" + (Object)((Object)this.machineType) + ", lib=" + this.lib + ", version=" + this.version + ", arg=" + this.arg + ", channel=" + this.channelUrl + " ]";
    }
}

