/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.metadata.db;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.metadata.Metadata;
import io.hops.hopsworks.common.dao.metadata.MetadataPK;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class MetadataFacade
extends AbstractFacade<Metadata> {
    private static final Logger LOGGER = Logger.getLogger(MetadataFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public MetadataFacade() {
        super(Metadata.class);
    }

    public Metadata getMetadata(MetadataPK metadataPK) {
        TypedQuery q = this.em.createNamedQuery("Metadata.findByPrimaryKey", Metadata.class);
        q.setParameter("metadataPK", (Object)metadataPK);
        try {
            return (Metadata)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Metadata getMetadataById(int id) {
        TypedQuery q = this.em.createNamedQuery("Metadata.findById", Metadata.class);
        q.setParameter("id", (Object)id);
        try {
            return (Metadata)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void addMetadata(Metadata metadata) {
        try {
            Metadata m;
            Metadata metadata2 = m = this.contains(metadata) ? metadata : this.getMetadata(metadata.getMetadataPK());
            if (m != null && m.getMetadataPK().getTupleid() != -1 && m.getMetadataPK().getFieldid() != -1) {
                m.copy(metadata);
                this.em.merge((Object)m);
            } else {
                m = metadata;
                this.em.persist((Object)m);
            }
            this.em.flush();
            this.em.clear();
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
    }

    public void removeMetadata(Metadata metadata) {
        try {
            Metadata m;
            Metadata metadata2 = m = this.contains(metadata) ? metadata : this.getMetadata(metadata.getMetadataPK());
            if (m != null && m.getMetadataPK().getTupleid() != -1 && m.getMetadataPK().getFieldid() != -1) {
                m.copy(metadata);
                this.em.remove((Object)m);
            }
            this.em.flush();
            this.em.clear();
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
    }

    public boolean contains(Metadata metadata) {
        return this.em.contains((Object)metadata);
    }
}

