/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import io.hops.hopsworks.common.provenance.app.ProvAParser;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.state.ProvSParser;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.elasticsearch.search.sort.SortOrder;
import org.javatuples.Pair;

public class ProvFileStateParamBuilder {
    private Map<String, ProvParser.FilterVal> fileStateFilter = new HashMap<String, ProvParser.FilterVal>();
    private List<Pair<ProvParser.Field, SortOrder>> fileStateSortBy = new ArrayList<Pair<ProvParser.Field, SortOrder>>();
    private Map<String, String> exactXAttrFilter = new HashMap<String, String>();
    private Map<String, String> likeXAttrFilter = new HashMap<String, String>();
    private Set<String> hasXAttrFilter = new HashSet<String>();
    private List<SortE> xAttrSortBy = new ArrayList<SortE>();
    private Set<ProvParser.Expansions> expansions = new HashSet<ProvParser.Expansions>();
    private Map<String, ProvParser.FilterVal> appStateFilter = new HashMap<String, ProvParser.FilterVal>();
    private Pair<Integer, Integer> pagination = null;

    public ProvFileStateParamBuilder withQueryParamFileStateFilterBy(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            ProvParser.addToFilters(this.fileStateFilter, ProvSParser.extractFilter(param));
        }
        return this;
    }

    public ProvFileStateParamBuilder withQueryParamExactXAttr(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<String, String> p = ProvParser.extractXAttrParam(param);
            this.exactXAttrFilter.put((String)p.getValue0(), (String)p.getValue1());
        }
        return this;
    }

    public ProvFileStateParamBuilder withQueryParamLikeXAttr(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<String, String> p = ProvParser.extractXAttrParam(param);
            this.likeXAttrFilter.put((String)p.getValue0(), (String)p.getValue1());
        }
        return this;
    }

    public ProvFileStateParamBuilder withQueryParamExpansions(Set<String> params) throws ProvenanceException {
        ProvParser.withExpansions(this.expansions, params);
        return this;
    }

    public ProvFileStateParamBuilder withQueryParamAppExpansionFilter(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            ProvParser.addToFilters(this.appStateFilter, ProvAParser.extractFilter(param));
        }
        return this;
    }

    public ProvFileStateParamBuilder withPagination(Integer offset, Integer limit) throws ProvenanceException {
        this.pagination = Pair.with((Object)offset, (Object)limit);
        return this;
    }

    public Map<String, ProvParser.FilterVal> getFileStateFilter() {
        return this.fileStateFilter;
    }

    public List<Pair<ProvParser.Field, SortOrder>> getFileStateSortBy() {
        return this.fileStateSortBy;
    }

    public Map<String, String> getExactXAttrFilter() {
        return this.exactXAttrFilter;
    }

    public Map<String, String> getLikeXAttrFilter() {
        return this.likeXAttrFilter;
    }

    public Set<String> getHasXAttrFilter() {
        return this.hasXAttrFilter;
    }

    public List<SortE> getXAttrSortBy() {
        return this.xAttrSortBy;
    }

    public Set<ProvParser.Expansions> getExpansions() {
        return this.expansions;
    }

    public Map<String, ProvParser.FilterVal> getAppStateFilter() {
        return this.appStateFilter;
    }

    public Pair<Integer, Integer> getPagination() {
        return this.pagination;
    }

    public ProvFileStateParamBuilder withProjectInodeId(Long projectInodeId) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.PROJECT_I_ID, (Object)projectInodeId));
        return this;
    }

    public ProvFileStateParamBuilder withFileInodeId(Long inodeId) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.FILE_I_ID, (Object)inodeId));
        return this;
    }

    public ProvFileStateParamBuilder withFileName(String fileName) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.FILE_NAME, (Object)fileName));
        return this;
    }

    public ProvFileStateParamBuilder withFileNameLike(String fileName) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.StateAux.FILE_NAME_LIKE, (Object)fileName));
        return this;
    }

    public ProvFileStateParamBuilder withUserId(String userId) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.USER_ID, (Object)userId));
        return this;
    }

    public ProvFileStateParamBuilder createdBefore(Long timestamp) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.StateAux.CREATE_TIMESTAMP_LT, (Object)timestamp));
        return this;
    }

    public ProvFileStateParamBuilder createdAfter(Long timestamp) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.StateAux.CREATE_TIMESTAMP_GT, (Object)timestamp));
        return this;
    }

    public ProvFileStateParamBuilder createdOn(Long timestamp) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.CREATE_TIMESTAMP, (Object)timestamp));
        return this;
    }

    public ProvFileStateParamBuilder withAppId(String appId) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.APP_ID, (Object)appId));
        return this;
    }

    public ProvFileStateParamBuilder withMlId(String mlId) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.ML_ID, (Object)mlId));
        return this;
    }

    public ProvFileStateParamBuilder withMlType(String mlType) throws ProvenanceException {
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvSParser.State.ML_TYPE, (Object)mlType));
        return this;
    }

    public ProvFileStateParamBuilder withXAttrs(Map<String, String> xAttrs) {
        for (Map.Entry<String, String> xAttr : xAttrs.entrySet()) {
            this.withXAttr(xAttr.getKey(), xAttr.getValue());
        }
        return this;
    }

    public ProvFileStateParamBuilder withXAttr(String key, String val) {
        String xattrKey = ProvParser.processXAttrKey(key);
        this.exactXAttrFilter.put(xattrKey, val);
        return this;
    }

    public ProvFileStateParamBuilder withXAttrsLike(Map<String, String> xAttrs) {
        for (Map.Entry<String, String> xAttr : xAttrs.entrySet()) {
            this.withXAttrLike(xAttr.getKey(), xAttr.getValue());
        }
        return this;
    }

    public ProvFileStateParamBuilder withXAttrLike(String key, String val) {
        String xattrKey = ProvParser.processXAttrKey(key);
        this.likeXAttrFilter.put(xattrKey, val);
        return this;
    }

    public ProvFileStateParamBuilder withAppExpansion() {
        this.expansions.add(ProvParser.Expansions.APP);
        return this;
    }

    public ProvFileStateParamBuilder withAppExpansionCurrentState(Provenance.AppState currentAppState) throws ProvenanceException {
        this.withAppExpansion();
        ProvParser.addToFilters(this.appStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvAParser.Field.APP_STATE, (Object)currentAppState.name()));
        return this;
    }

    public ProvFileStateParamBuilder withAppExpansion(String appId) throws ProvenanceException {
        this.withAppExpansion();
        ProvParser.addToFilters(this.appStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvAParser.Field.APP_ID, (Object)appId));
        return this;
    }

    public ProvFileStateParamBuilder withQueryParamFileStateSortBy(List<String> params) throws ProvenanceException {
        for (String param : params) {
            this.fileStateSortBy.add(ProvSParser.extractSort(param));
        }
        return this;
    }

    public ProvFileStateParamBuilder withQueryParamXAttrSortBy(List<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<String, String> xattr = ProvParser.extractXAttrParam(param);
            SortOrder order = ProvParser.extractSortOrder((String)xattr.getValue1());
            this.xAttrSortBy.add(new SortE((String)xattr.getValue0(), order));
        }
        return this;
    }

    public ProvFileStateParamBuilder sortBy(String field, SortOrder order) {
        try {
            ProvParser.Field sortField = ProvSParser.extractField(field);
            this.fileStateSortBy.add((Pair<ProvParser.Field, SortOrder>)Pair.with((Object)sortField, (Object)order));
        }
        catch (ProvenanceException ex) {
            String xattrKey = ProvParser.processXAttrKey(field);
            this.xAttrSortBy.add(new SortE(xattrKey, order));
        }
        return this;
    }

    public void fixSortBy(String index, Map<String, String> mapping) throws ProvenanceException {
        for (SortE s : this.xAttrSortBy) {
            String type = mapping.get(s.key);
            if (type == null) {
                String devMsg = "missing mapping for field[" + s.key + "] - index[" + index + "] - ";
                String usrMsg = "bad field[" + s.key + "]";
                ProvenanceException ex = new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, usrMsg, devMsg);
                throw ex;
            }
            if (!type.equals("text")) continue;
            s.key = s.key + ".keyword";
        }
    }

    public ProvFileStateParamBuilder filterByStateField(ProvParser.Field field, String val) throws ProvenanceException {
        if (!(field instanceof ProvSParser.State) && !(field instanceof ProvSParser.StateAux)) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "allowed fields - FileState and fileStateAux");
        }
        Object v = field.filterValParser().apply(val);
        ProvParser.addToFilters(this.fileStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)field, v));
        return this;
    }

    public ProvFileStateParamBuilder filterByHasXAttr(String key) {
        String xattrKey = ProvParser.processXAttrKey(key);
        this.hasXAttrFilter.add(xattrKey);
        return this;
    }

    public ProvFileStateParamBuilder filterByHasXAttr(Set<String> keys) {
        for (String key : keys) {
            String xattrKey = ProvParser.processXAttrKey(key);
            this.hasXAttrFilter.add(xattrKey);
        }
        return this;
    }

    public boolean hasAppExpansion() {
        return this.expansions.contains((Object)ProvParser.Expansions.APP);
    }

    public static class SortE {
        public String key;
        public SortOrder order;

        public SortE(String key, SortOrder order) {
            this.key = key;
            this.order = order;
        }
    }
}

