/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.ondemand;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.common.featurestore.feature.FeaturestoreFeatureController;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
public class OnDemandFeaturegroupController {
    @EJB
    private OnDemandFeaturegroupFacade onDemandFeaturegroupFacade;
    @EJB
    private FeaturestoreJdbcConnectorFacade featurestoreJdbcConnectorFacade;
    @EJB
    private FeaturestoreFeatureController featurestoreFeatureController;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public OnDemandFeaturegroup createOnDemandFeaturegroup(OnDemandFeaturegroupDTO onDemandFeaturegroupDTO) throws FeaturestoreException {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = this.verifyOnDemandFeaturegroupJdbcConnector(onDemandFeaturegroupDTO.getJdbcConnectorId());
        this.verifyOnDemandFeaturegroupSqlQuery(onDemandFeaturegroupDTO.getQuery());
        OnDemandFeaturegroup onDemandFeaturegroup = new OnDemandFeaturegroup();
        onDemandFeaturegroup.setDescription(onDemandFeaturegroupDTO.getDescription());
        onDemandFeaturegroup.setName(onDemandFeaturegroupDTO.getName());
        onDemandFeaturegroup.setFeaturestoreJdbcConnector(featurestoreJdbcConnector);
        onDemandFeaturegroup.setQuery(onDemandFeaturegroupDTO.getQuery());
        this.onDemandFeaturegroupFacade.persist(onDemandFeaturegroup);
        this.featurestoreFeatureController.updateOnDemandFeaturegroupFeatures(onDemandFeaturegroup, onDemandFeaturegroupDTO.getFeatures());
        return onDemandFeaturegroup;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void updateOnDemandFeaturegroupMetadata(OnDemandFeaturegroup onDemandFeaturegroup, OnDemandFeaturegroupDTO onDemandFeaturegroupDTO) throws FeaturestoreException {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = this.verifyOnDemandFeaturegroupJdbcConnector(onDemandFeaturegroupDTO.getJdbcConnectorId());
        this.verifyOnDemandFeaturegroupSqlQuery(onDemandFeaturegroupDTO.getQuery());
        onDemandFeaturegroup.setName(onDemandFeaturegroupDTO.getName());
        onDemandFeaturegroup.setDescription(onDemandFeaturegroupDTO.getDescription());
        onDemandFeaturegroup.setFeaturestoreJdbcConnector(featurestoreJdbcConnector);
        onDemandFeaturegroup.setQuery(onDemandFeaturegroupDTO.getQuery());
        this.onDemandFeaturegroupFacade.updateMetadata(onDemandFeaturegroup);
        this.featurestoreFeatureController.updateOnDemandFeaturegroupFeatures(onDemandFeaturegroup, onDemandFeaturegroupDTO.getFeatures());
    }

    private FeaturestoreJdbcConnector verifyOnDemandFeaturegroupJdbcConnector(Integer jdbcConnectorId) throws FeaturestoreException {
        if (jdbcConnectorId == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.JDBC_CONNECTOR_ID_NOT_PROVIDED.getMessage());
        }
        FeaturestoreJdbcConnector featurestoreJdbcConnector = (FeaturestoreJdbcConnector)this.featurestoreJdbcConnectorFacade.find(jdbcConnectorId);
        if (featurestoreJdbcConnector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.JDBC_CONNECTOR_NOT_FOUND, Level.FINE, "JDBC connector with id: " + jdbcConnectorId + " was not found");
        }
        return featurestoreJdbcConnector;
    }

    private void verifyOnDemandFeaturegroupSqlQuery(String query) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)query)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_SQL_QUERY, Level.FINE, ", SQL Query cannot be empty");
        }
        if (query.length() > 11000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_SQL_QUERY, Level.FINE, ", SQL Query cannot exceed 11000characters.");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public OnDemandFeaturegroup removeOnDemandFeaturegroup(OnDemandFeaturegroup onDemandFeaturegroup) {
        this.onDemandFeaturegroupFacade.remove(onDemandFeaturegroup);
        return onDemandFeaturegroup;
    }
}

