/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.kafka;

import io.hops.hopsworks.common.dao.kafka.schemas.Schemas;
import io.hops.hopsworks.common.dao.kafka.schemas.SchemasFacade;
import io.hops.hopsworks.common.dao.kafka.schemas.SubjectDTO;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.exceptions.SchemaException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class SchemasController {
    private static final Logger LOGGER = Logger.getLogger(SchemasController.class.getName());
    @EJB
    private SchemasFacade schemasFacade;

    public Schemas addNewSchema(Project project, String schemaString) throws SchemaException {
        Schema schema = this.validateSchema(project, schemaString);
        Optional<Schemas> current = this.schemasFacade.findBySchema(project, schema.toString());
        if (current.isPresent()) {
            return current.get();
        }
        Schemas s = new Schemas(schema.toString(), project);
        this.schemasFacade.save(s);
        return s;
    }

    private Schema validateSchema(Project project, String schema) throws SchemaException {
        if (schema == null) {
            throw new IllegalArgumentException("No schema provided");
        }
        try {
            Schema s = new Schema.Parser().parse(schema);
            return s;
        }
        catch (SchemaParseException e) {
            throw new SchemaException(RESTCodes.SchemaRegistryErrorCode.INVALID_AVRO_SCHEMA, Level.FINE, "project=" + project.getName() + ", schema=" + schema);
        }
    }

    public SubjectDTO findSchemaById(Project project, Integer id) throws SchemaException {
        Schemas schema = this.schemasFacade.findSchemaById(project, id).orElseThrow(() -> new SchemaException(RESTCodes.SchemaRegistryErrorCode.SCHEMA_NOT_FOUND, Level.FINE, "project=" + project.getName() + ", schema_id=" + id));
        return new SubjectDTO(schema.getSchema());
    }
}

