/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWith;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.elastic.ElasticClient;
import io.hops.hopsworks.common.elastic.ElasticHit;
import io.hops.hopsworks.common.elastic.ElasticUtils;
import io.hops.hopsworks.common.elastic.KibanaClient;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ElasticController {
    @EJB
    private Settings settings;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private ElasticClient elasticClient;
    @EJB
    private KibanaClient kibanaClient;
    private static final Logger LOG = Logger.getLogger(ElasticController.class.getName());

    public List<ElasticHit> globalSearch(String searchTerm) throws ServiceException, ElasticException {
        RestHighLevelClient client = this.getClient();
        if (!this.indexExists(client, "projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        LOG.log(Level.INFO, "Found elastic index, now executing the query.");
        SearchResponse response = this.executeSearchQuery(client, this.globalSearchQuery(searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            LinkedList<ElasticHit> elasticHits = new LinkedList<ElasticHit>();
            if (response.getHits().getHits().length > 0) {
                SearchHit[] hits;
                for (SearchHit hit : hits = response.getHits().getHits()) {
                    ElasticHit eHit = new ElasticHit(hit);
                    eHit.setLocalDataset(true);
                    long inode_id = Long.parseLong(hit.getId());
                    Dataset dsl = this.datasetController.getDatasetByInodeId(inode_id);
                    if (dsl != null && dsl.isPublicDs()) {
                        Dataset ds = dsl;
                        eHit.setPublicId(ds.getPublicDsId());
                    }
                    elasticHits.add(eHit);
                }
            }
            return elasticHits;
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public List<ElasticHit> projectSearch(Integer projectId, String searchTerm) throws ServiceException, ElasticException {
        RestHighLevelClient client = this.getClient();
        if (!this.indexExists(client, "projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        SearchResponse response = this.executeSearchQuery(client, this.projectSearchQuery(projectId, searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            LinkedList<ElasticHit> elasticHits = new LinkedList<ElasticHit>();
            if (response.getHits().getHits().length > 0) {
                SearchHit[] hits;
                for (SearchHit hit : hits = response.getHits().getHits()) {
                    ElasticHit eHit = new ElasticHit(hit);
                    eHit.setLocalDataset(true);
                    elasticHits.add(eHit);
                }
            }
            this.projectSearchInSharedDatasets(client, projectId, searchTerm, elasticHits);
            return elasticHits;
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public List<ElasticHit> datasetSearch(Integer projectId, String datasetName, String searchTerm) throws ServiceException, ElasticException {
        Project project;
        RestHighLevelClient client = this.getClient();
        if (!this.indexExists(client, "projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        String dsName = datasetName;
        if (datasetName.contains("::")) {
            String[] sharedDS = datasetName.split("::");
            dsName = sharedDS[1];
            project = this.projectFacade.findByName(sharedDS[0]);
        } else {
            project = this.projectFacade.find(projectId);
        }
        Dataset dataset = this.datasetController.getByProjectAndDsName(project, null, dsName);
        long datasetId = dataset.getInodeId();
        SearchResponse response = this.executeSearchQuery(client, this.datasetSearchQuery(datasetId, searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            LinkedList<ElasticHit> elasticHits = new LinkedList<ElasticHit>();
            if (response.getHits().getHits().length > 0) {
                SearchHit[] hits;
                for (SearchHit hit : hits = response.getHits().getHits()) {
                    ElasticHit eHit = new ElasticHit(hit);
                    eHit.setLocalDataset(true);
                    elasticHits.add(eHit);
                }
            }
            return elasticHits;
        }
        throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public boolean deleteIndex(String index) throws ElasticException {
        boolean acked = false;
        try {
            acked = this.getClient().indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.INFO, "Error while deleting an index", e.getMessage(), (Throwable)e);
        }
        if (acked) {
            LOG.log(Level.INFO, "Acknowledged deletion of elastic index:{0}", index);
        } else {
            LOG.log(Level.SEVERE, "Elastic index:{0} deletion could not be acknowledged", index);
        }
        return acked;
    }

    public boolean indexExists(String index) throws ElasticException {
        boolean exists = this.indexExists(this.getClient(), index);
        if (exists) {
            LOG.log(Level.FINE, "Elastic index found:{0}", index);
        } else {
            LOG.log(Level.FINE, "Elastic index:{0} could not be found", index);
        }
        return exists;
    }

    public void createIndex(String index) throws ServiceException, ElasticException {
        boolean acked = false;
        try {
            acked = this.getClient().indices().create(new CreateIndexRequest(index), RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.INFO, "Error while creating an index", e.getMessage(), (Throwable)e);
        }
        if (!acked) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_CREATION_ERROR, Level.SEVERE, "Elastic index:{0} creation could not be acknowledged. index: " + index);
        }
    }

    public void createIndexPattern(Project project, Users user, String pattern) throws ProjectException, ElasticException {
        JSONObject resp = this.kibanaClient.createIndexPattern(user, project, KibanaClient.KibanaType.IndexPattern, pattern);
        if (!(resp.has("updated_at") || resp.has("statusCode") && resp.get("statusCode").toString().equals("409"))) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_KIBANA_CREATE_INDEX_ERROR, Level.SEVERE, null, "project: " + project.getName() + ", resp: " + resp.toString(2), null);
        }
    }

    public JSONObject deleteIndexPattern(Project project, String pattern) throws ElasticException {
        return this.kibanaClient.deleteAsDataOwner(project, KibanaClient.KibanaType.IndexPattern, pattern);
    }

    public JSONObject updateKibana(Project project, Users user, KibanaClient.KibanaType type, String id, String data) throws ElasticException {
        return this.kibanaClient.postWithOverwrite(user, project, type, id, data);
    }

    public void deleteProjectIndices(Project project) throws ElasticException {
        Map<String, Long> indices = this.getIndices(project.getName() + "_(((logs|serving|" + "_beamsdkworker-*" + "|" + "_beamjobserver-*" + ")-\\d{4}.\\d{2}.\\d{2})|(" + "_kagent-*" + "))");
        for (String index : indices.keySet()) {
            if (this.deleteIndex(index)) continue;
            LOG.log(Level.SEVERE, "Could not delete project index:{0}", index);
        }
    }

    public void deleteProjectSavedObjects(String project) throws ElasticException {
        if (!this.settings.isKibanaMultiTenancyEnabled().booleanValue()) {
            throw new UnsupportedOperationException("Only multitenant kibana setup supported.");
        }
        this.deleteIndex(ElasticUtils.getAllKibanaTenantIndex(project));
    }

    public Map<String, Long> getIndices(String regex) throws ElasticException {
        try {
            RestHighLevelClient client = this.getClient();
            Response response = client.getLowLevelClient().performRequest(new Request("GET", "/_cat/indices?h=i,creation.date&format=json"));
            JSONArray jsonArray = new JSONArray(EntityUtils.toString((HttpEntity)response.getEntity()));
            HashMap<String, Long> indicesMap = new HashMap<String, Long>();
            Pattern pattern = null;
            if (regex != null) {
                pattern = Pattern.compile(regex);
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject index = jsonArray.getJSONObject(i);
                String indexName = index.getString("i");
                Long creationDate = index.getLong("creation.date");
                if (pattern != null && !pattern.matcher(indexName).matches()) continue;
                indicesMap.put(indexName, creationDate);
            }
            return indicesMap;
        }
        catch (IOException e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.INFO, "Error while getting all indices", e.getMessage(), (Throwable)e);
        }
    }

    private RestHighLevelClient getClient() throws ElasticException {
        return this.elasticClient.getClient();
    }

    private void projectSearchInSharedDatasets(RestHighLevelClient client, Integer projectId, String searchTerm, List<ElasticHit> elasticHits) throws ServiceException {
        Project project = this.projectFacade.find(projectId);
        Collection<DatasetSharedWith> datasetSharedWithCollection = project.getDatasetSharedWithCollectionCollection();
        for (DatasetSharedWith ds : datasetSharedWithCollection) {
            long datasetId = ds.getDataset().getInode().getId();
            this.executeProjectSearchQuery(client, this.searchSpecificDataset(datasetId, searchTerm), elasticHits);
            this.executeProjectSearchQuery(client, this.datasetSearchQuery(datasetId, searchTerm), elasticHits);
        }
    }

    private void executeProjectSearchQuery(RestHighLevelClient client, QueryBuilder query, List<ElasticHit> elasticHits) throws ServiceException {
        SearchResponse response = this.executeSearchQuery(client, query);
        if (response.status().getStatus() == 200 && response.getHits().getHits().length > 0) {
            SearchHit[] hits;
            for (SearchHit hit : hits = response.getHits().getHits()) {
                elasticHits.add(new ElasticHit(hit));
            }
        }
    }

    private SearchResponse executeSearchQuery(RestHighLevelClient client, QueryBuilder query) throws ServiceException {
        return this.executeSearchQuery(client, "projects", query);
    }

    private SearchResponse executeSearchQuery(RestHighLevelClient client, String index, QueryBuilder query) throws ServiceException {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sb = new SearchSourceBuilder();
        sb.query(query);
        searchRequest.source(sb);
        LOG.log(Level.INFO, "Search Elastic query is: {0}", searchRequest);
        try {
            return client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_SERVER_NOT_FOUND, Level.SEVERE, "Error while executing search", e.getMessage());
        }
    }

    private QueryBuilder searchSpecificDataset(Long datasetId, String searchTerm) {
        MatchQueryBuilder dataset = QueryBuilders.matchQuery((String)"_id", (Object)datasetId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        return QueryBuilders.boolQuery().must((QueryBuilder)dataset).must(nameDescQuery);
    }

    private QueryBuilder globalSearchQuery(String searchTerm) {
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndProjectsQuery = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "proj"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)onlyDatasetsAndProjectsQuery).must(nameDescQuery);
        return query;
    }

    private QueryBuilder projectSearchQuery(Integer projectId, String searchTerm) {
        TermQueryBuilder projectIdQuery = QueryBuilders.termQuery((String)"project_id", (Object)projectId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndInodes = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "inode"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)projectIdQuery).must((QueryBuilder)onlyDatasetsAndInodes).must(nameDescQuery);
        return query;
    }

    private QueryBuilder datasetSearchQuery(long datasetId, String searchTerm) {
        TermQueryBuilder datasetIdQuery = QueryBuilders.termQuery((String)"dataset_id", (long)datasetId);
        QueryBuilder query = this.getNameDescriptionMetadataQuery(searchTerm);
        TermQueryBuilder onlyInodes = QueryBuilders.termQuery((String)"doc_type", (String)"inode");
        BoolQueryBuilder cq = QueryBuilders.boolQuery().must((QueryBuilder)datasetIdQuery).must((QueryBuilder)onlyInodes).must(query);
        return cq;
    }

    private QueryBuilder getNameDescriptionMetadataQuery(String searchTerm) {
        QueryBuilder nameQuery = this.getNameQuery(searchTerm);
        QueryBuilder descriptionQuery = this.getDescriptionQuery(searchTerm);
        QueryBuilder metadataQuery = this.getMetadataQuery(searchTerm);
        BoolQueryBuilder textCondition = QueryBuilders.boolQuery().should(nameQuery).should(descriptionQuery).should(metadataQuery);
        return textCondition;
    }

    private QueryBuilder getNameQuery(String searchTerm) {
        PrefixQueryBuilder namePrefixMatch = QueryBuilders.prefixQuery((String)"name", (String)searchTerm);
        MatchPhraseQueryBuilder namePhraseMatch = QueryBuilders.matchPhraseQuery((String)"name", (Object)searchTerm);
        FuzzyQueryBuilder nameFuzzyQuery = QueryBuilders.fuzzyQuery((String)"name", (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)"name", (String)String.format("*%s*", searchTerm));
        BoolQueryBuilder nameQuery = QueryBuilders.boolQuery().should((QueryBuilder)namePrefixMatch).should((QueryBuilder)namePhraseMatch).should((QueryBuilder)nameFuzzyQuery).should((QueryBuilder)wildCardQuery);
        return nameQuery;
    }

    private QueryBuilder getDescriptionQuery(String searchTerm) {
        PrefixQueryBuilder descriptionPrefixMatch = QueryBuilders.prefixQuery((String)"description", (String)searchTerm);
        TermsQueryBuilder descriptionMatch = QueryBuilders.termsQuery((String)"description", (String[])new String[]{searchTerm});
        MatchPhraseQueryBuilder descriptionPhraseMatch = QueryBuilders.matchPhraseQuery((String)"description", (Object)searchTerm);
        FuzzyQueryBuilder descriptionFuzzyQuery = QueryBuilders.fuzzyQuery((String)"description", (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)"description", (String)String.format("*%s*", searchTerm));
        BoolQueryBuilder descriptionQuery = QueryBuilders.boolQuery().should((QueryBuilder)descriptionPrefixMatch).should((QueryBuilder)descriptionMatch).should((QueryBuilder)descriptionPhraseMatch).should((QueryBuilder)descriptionFuzzyQuery).should((QueryBuilder)wildCardQuery);
        return descriptionQuery;
    }

    private QueryBuilder getMetadataQuery(String searchTerm) {
        QueryStringQueryBuilder metadataQuery = QueryBuilders.queryStringQuery((String)String.format("*%s*", searchTerm)).lenient(Boolean.TRUE).field("xattr.*");
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"xattr", (QueryBuilder)metadataQuery, (ScoreMode)ScoreMode.Avg);
        return nestedQuery;
    }

    private boolean indexExists(RestHighLevelClient client, String indexName) throws ElasticException {
        try {
            return client.indices().exists(new GetIndexRequest(new String[]{indexName}), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.INFO, "Error while checking index existence", e.getMessage(), (Throwable)e);
        }
    }
}

