/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.hops.hopsworks.common.dao.airflow.MaterializedJWT;
import io.hops.hopsworks.common.dao.airflow.MaterializedJWTFacade;
import io.hops.hopsworks.common.dao.airflow.MaterializedJWTID;
import io.hops.hopsworks.common.dao.jupyter.JupyterProject;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettings;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettingsFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterManager;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.jupyter.JupyterJWT;
import io.hops.hopsworks.common.jupyter.JupyterJWTTokenWriter;
import io.hops.hopsworks.common.jupyter.PidAndPort;
import io.hops.hopsworks.common.user.UsersController;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.jwt.JWTController;
import io.hops.hopsworks.jwt.SignatureAlgorithm;
import io.hops.hopsworks.jwt.exception.InvalidationException;
import io.hops.hopsworks.jwt.exception.JWTException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.AccessTimeout;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@DependsOn(value={"Settings"})
public class JupyterJWTManager {
    private static final Logger LOG = Logger.getLogger(JupyterJWTManager.class.getName());
    public static final String TOKEN_FILE_NAME = "token.jwt";
    private final TreeSet<JupyterJWT> jupyterJWTs = new TreeSet<JupyterJWT>(new Comparator<JupyterJWT>(){

        @Override
        public int compare(JupyterJWT t0, JupyterJWT t1) {
            if (t0.equals(t1)) {
                return 0;
            }
            if (t0.expiration.isBefore(t1.expiration)) {
                return -1;
            }
            if (t0.expiration.isAfter(t1.expiration)) {
                return 1;
            }
            return 0;
        }
    });
    private final HashMap<PidAndPort, JupyterJWT> pidAndPortToJWT = new HashMap();
    @EJB
    private Settings settings;
    @EJB
    private MaterializedJWTFacade materializedJWTFacade;
    @EJB
    private JWTController jwtController;
    @EJB
    private UsersController usersController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private JupyterFacade jupyterFacade;
    @Inject
    private JupyterManager jupyterManager;
    @EJB
    private JupyterSettingsFacade jupyterSettingsFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private UserFacade userFacade;
    @Inject
    private JupyterJWTTokenWriter jupyterJWTTokenWriter;
    @Resource
    private TimerService timerService;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init() {
        try {
            this.recover();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception while recovering Jupyter JWTs. Keep going on...", ex);
        }
        long monitorInterval = 5000L;
        this.timerService.createIntervalTimer(1000L, monitorInterval, new TimerConfig((Serializable)((Object)"Jupyter JWT renewal service"), false));
    }

    private void addToken(JupyterJWT jupyterJWT) {
        this.jupyterJWTs.add(jupyterJWT);
        this.pidAndPortToJWT.put(jupyterJWT.pidAndPort, jupyterJWT);
    }

    private void removeToken(PidAndPort pidAndPort) {
        JupyterJWT jupyterJWT = this.pidAndPortToJWT.remove(pidAndPort);
        this.jupyterJWTs.remove(jupyterJWT);
    }

    private void recover() {
        LOG.log(Level.INFO, "Starting Jupyter JWT manager recovery");
        ArrayList<MaterializedJWT> failed2recover = new ArrayList<MaterializedJWT>();
        for (MaterializedJWT materializedJWT : this.materializedJWTFacade.findAll4Jupyter()) {
            LOG.log(Level.FINEST, "Recovering Jupyter JWT " + materializedJWT.getIdentifier());
            Project project = this.projectFacade.find(materializedJWT.getIdentifier().getProjectId());
            Users user = (Users)this.userFacade.find(materializedJWT.getIdentifier().getUserId());
            if (project == null || user == null) {
                LOG.log(Level.WARNING, "Tried to recover " + materializedJWT.getIdentifier() + " but could not find either Project or User");
                failed2recover.add(materializedJWT);
                continue;
            }
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUsername);
            if (jupyterProject == null) {
                LOG.log(Level.FINEST, "There is no Jupyter configuration persisted for " + materializedJWT.getIdentifier());
                failed2recover.add(materializedJWT);
                continue;
            }
            if (!this.jupyterManager.ping(jupyterProject)) {
                LOG.log(Level.FINEST, "Jupyter server is not running for " + materializedJWT.getIdentifier() + " Skip recovering...");
                failed2recover.add(materializedJWT);
                continue;
            }
            JupyterSettings jupyterSettings = this.jupyterSettingsFacade.findByProjectUser(project.getId(), user.getEmail());
            Path tokenFile = this.constructTokenFilePath(jupyterSettings);
            String token = null;
            JupyterJWT jupyterJWT = null;
            PidAndPort pidAndPort = new PidAndPort(jupyterProject.getPid(), jupyterProject.getPort());
            try {
                token = FileUtils.readFileToString((File)tokenFile.toFile());
                DecodedJWT decodedJWT = this.jwtController.verifyToken(token, this.settings.getJWTIssuer());
                jupyterJWT = new JupyterJWT(project, user, pidAndPort, DateUtils.date2LocalDateTime(decodedJWT.getExpiresAt()));
                jupyterJWT.token = token;
                jupyterJWT.tokenFile = tokenFile;
                LOG.log(Level.FINE, "Successfully read existing JWT from local filesystem");
            }
            catch (JWTDecodeException | JWTException | IOException ex) {
                LOG.log(Level.FINE, "Could not recover Jupyter JWT from local filesystem, generating new!", ex);
                String[] audience = new String[]{"api"};
                LocalDateTime expirationDate = LocalDateTime.now().plus(this.settings.getJWTLifetimeMs(), ChronoUnit.MILLIS);
                String[] userRoles = this.usersController.getUserRoles(user).toArray(new String[1]);
                try {
                    HashMap<String, Object> claims = new HashMap<String, Object>(3);
                    claims.put("renewable", false);
                    claims.put("expLeeway", this.settings.getJWTExpLeewaySec());
                    claims.put("roles", userRoles);
                    token = this.jwtController.createToken(this.settings.getJWTSigningKeyName(), false, this.settings.getJWTIssuer(), audience, DateUtils.localDateTime2Date(expirationDate), DateUtils.localDateTime2Date(DateUtils.getNow()), user.getUsername(), claims, SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg()));
                    jupyterJWT = new JupyterJWT(project, user, pidAndPort, expirationDate);
                    jupyterJWT.token = token;
                    jupyterJWT.tokenFile = tokenFile;
                    this.jupyterJWTTokenWriter.writeToken(this.settings, jupyterJWT);
                    LOG.log(Level.FINE, "Generated new Jupyter JWT cause could not recover existing");
                }
                catch (IOException recIOEx) {
                    LOG.log(Level.WARNING, "Failed to recover Jupyter JWT for " + materializedJWT.getIdentifier() + ", generated new valid JWT but failed to write to local filesystem. Invalidating new token! Continue recovering...");
                    if (token != null) {
                        try {
                            this.jwtController.invalidate(token);
                        }
                        catch (InvalidationException invalidationException) {
                            // empty catch block
                        }
                    }
                    failed2recover.add(materializedJWT);
                    continue;
                }
                catch (JWTException | GeneralSecurityException jwtEx) {
                    LOG.log(Level.WARNING, "Failed to recover Jupyter JWT for " + materializedJWT.getIdentifier() + ", tried to generate new token and it failed as well. Could not recover! Continue recovering...");
                    failed2recover.add(materializedJWT);
                    continue;
                }
            }
            this.addToken(jupyterJWT);
        }
        for (MaterializedJWT failedRecovery : failed2recover) {
            this.materializedJWTFacade.delete(failedRecovery.getIdentifier());
        }
        LOG.log(Level.INFO, "Finished Jupyter JWT recovery");
    }

    private Path constructTokenFilePath(JupyterSettings jupyterSettings) {
        return Paths.get(this.settings.getStagingDir(), "/private_dirs/", jupyterSettings.getSecret(), TOKEN_FILE_NAME);
    }

    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=2000L)
    public void materializeJWT(Users user, Project project, JupyterSettings jupyterSettings, Long pid, Integer port, String[] audience) throws ServiceException {
        MaterializedJWTID materialID = new MaterializedJWTID(project.getId(), user.getUid(), MaterializedJWTID.USAGE.JUPYTER);
        if (!this.materializedJWTFacade.exists(materialID)) {
            LocalDateTime expirationDate = LocalDateTime.now().plus(this.settings.getJWTLifetimeMs(), ChronoUnit.MILLIS);
            JupyterJWT jupyterJWT = new JupyterJWT(project, user, new PidAndPort(pid, port), expirationDate);
            try {
                String[] roles = this.usersController.getUserRoles(user).toArray(new String[1]);
                MaterializedJWT materializedJWT = new MaterializedJWT(materialID);
                this.materializedJWTFacade.persist(materializedJWT);
                HashMap<String, Object> claims = new HashMap<String, Object>(3);
                claims.put("renewable", false);
                claims.put("expLeeway", this.settings.getJWTExpLeewaySec());
                claims.put("roles", roles);
                String token = this.jwtController.createToken(this.settings.getJWTSigningKeyName(), false, this.settings.getJWTIssuer(), audience, DateUtils.localDateTime2Date(expirationDate), DateUtils.localDateTime2Date(DateUtils.getNow()), user.getUsername(), claims, SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg()));
                jupyterJWT.tokenFile = this.constructTokenFilePath(jupyterSettings);
                jupyterJWT.token = token;
                this.jupyterJWTTokenWriter.writeToken(this.settings, jupyterJWT);
                this.addToken(jupyterJWT);
            }
            catch (JWTException | GeneralSecurityException ex) {
                LOG.log(Level.SEVERE, "Error generating Jupyter JWT for " + jupyterJWT, ex);
                this.materializedJWTFacade.delete(materialID);
                throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_START_ERROR, Level.SEVERE, "Could not generate Jupyter JWT", ex.getMessage(), ex);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Error writing Jupyter JWT to file for " + jupyterJWT, ex);
                this.materializedJWTFacade.delete(materialID);
                try {
                    this.jwtController.invalidate(jupyterJWT.token);
                }
                catch (InvalidationException invEx) {
                    LOG.log(Level.FINE, "Could not invalidate Jupyter JWT after failure to write to file", ex);
                }
                throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_START_ERROR, Level.SEVERE, "Could not write Jupyter JWT to file", ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=500L)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @Timeout
    public void monitorJupyterJWT() {
        JupyterJWT element;
        HashSet<JupyterJWT> renewedJWTs = new HashSet<JupyterJWT>(this.jupyterJWTs.size());
        Iterator<JupyterJWT> jupyterJWTs = this.jupyterJWTs.iterator();
        LocalDateTime now = DateUtils.getNow();
        while (jupyterJWTs.hasNext() && (element = jupyterJWTs.next()).maybeRenew(now)) {
            LocalDateTime newExpirationDate = now.plus(this.settings.getJWTLifetimeMs(), ChronoUnit.MILLIS);
            String newToken = null;
            try {
                newToken = this.jwtController.renewToken(element.token, DateUtils.localDateTime2Date(newExpirationDate), DateUtils.localDateTime2Date(now), true, new HashMap(3));
                JupyterJWT renewedJWT = new JupyterJWT(element.project, element.user, element.pidAndPort, newExpirationDate);
                renewedJWT.tokenFile = element.tokenFile;
                renewedJWT.token = newToken;
                this.jupyterJWTTokenWriter.writeToken(this.settings, renewedJWT);
                renewedJWTs.add(renewedJWT);
            }
            catch (JWTException ex) {
                LOG.log(Level.WARNING, "Could not renew Jupyter JWT for " + element, ex);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not write renewed Jupyter JWT to file for " + element, ex);
                if (newToken == null) continue;
                try {
                    this.jwtController.invalidate(newToken);
                }
                catch (InvalidationException invEx) {
                    LOG.log(Level.FINE, "Could not invalidate failed token", invEx);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Generic error renewing Jupyter JWT for " + element, ex);
            }
        }
        renewedJWTs.forEach(t -> {
            this.removeToken(t.pidAndPort);
            this.addToken((JupyterJWT)t);
        });
    }

    @Lock(value=LockType.WRITE)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void cleanJWT(Long pid, Integer port) {
        Optional<JupyterJWT> optional = Optional.ofNullable(this.pidAndPortToJWT.get(new PidAndPort(pid, port)));
        if (!optional.isPresent()) {
            LOG.log(Level.WARNING, "JupyterJWT not found for pid " + pid + " and port " + port);
            return;
        }
        JupyterJWT element = optional.get();
        try {
            MaterializedJWTID materializedJWTID = new MaterializedJWTID(element.project.getId(), element.user.getUid(), MaterializedJWTID.USAGE.JUPYTER);
            MaterializedJWT material = this.materializedJWTFacade.findById(materializedJWTID);
            this.jupyterJWTTokenWriter.deleteToken(element);
            if (material != null) {
                this.materializedJWTFacade.delete(materializedJWTID);
            }
            this.removeToken(element.pidAndPort);
            this.jwtController.invalidate(element.token);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Could not determine if Jupyter JWT for " + element + " is still valid. Renewing it...");
        }
    }
}

