/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.EnumSet;
import java.util.logging.Level;
import org.elasticsearch.search.sort.SortOrder;
import org.javatuples.Pair;

public class ProvSParser {
    public static Pair<ProvParser.Field, Object> extractFilter(String param) throws ProvenanceException {
        String rawVal;
        String rawFilter;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawFilter = param.substring(0, aux);
            rawVal = param.substring(aux + 1);
        } else {
            rawFilter = param;
            rawVal = "true";
        }
        ProvParser.Field field = ProvSParser.extractField(rawFilter);
        Object val = field.filterValParser().apply(rawVal);
        return Pair.with((Object)field, val);
    }

    public static ProvParser.Field extractField(String val) throws ProvenanceException {
        try {
            return State.valueOf(val.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            try {
                return StateAux.valueOf(val.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException2) {
                StringBuilder supported = new StringBuilder();
                supported.append(EnumSet.allOf(State.class));
                supported.append(EnumSet.allOf(StateAux.class));
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "filter param" + val + " not supported - supported:" + supported, "exception extracting SortBy param");
            }
        }
    }

    public static Pair<ProvParser.Field, SortOrder> extractSort(String param) throws ProvenanceException {
        String rawSortOrder;
        String rawSortField;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawSortField = param.substring(0, aux);
            rawSortOrder = param.substring(aux + 1);
        } else {
            rawSortField = param;
            rawSortOrder = "ASC";
        }
        ProvParser.Field sortField = ProvSParser.extractField(rawSortField);
        SortOrder sortOrder = ProvParser.extractSortOrder(rawSortOrder);
        return Pair.with((Object)sortField, (Object)sortOrder);
    }

    public static enum StateAux implements ProvParser.Field
    {
        FILE_NAME_LIKE(State.FILE_NAME, ProvParser.FilterType.LIKE),
        CREATE_TIMESTAMP_LT(State.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_LT),
        CREATE_TIMESTAMP_LTE(State.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_LTE),
        CREATE_TIMESTAMP_GT(State.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_GT),
        CREATE_TIMESTAMP_GTE(State.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_GTE),
        CREATETIME(State.CREATE_TIMESTAMP, ProvParser.FilterType.EXACT);

        State base;
        ProvParser.FilterType filterType;

        private StateAux(State base, ProvParser.FilterType filterType) {
            this.base = base;
            this.filterType = filterType;
        }

        @Override
        public String elasticFieldName() {
            return this.base.elasticFieldName();
        }

        @Override
        public String queryFieldName() {
            return this.base.elasticFieldName();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return this.filterType;
        }

        public ProvParser.ValParser filterValParser() {
            return this.base.filterValParser();
        }
    }

    public static enum State implements ProvParser.Field
    {
        PROJECT_I_ID(ProvParser.BaseField.PROJECT_I_ID, new ProvParser.LongValParser()),
        DATASET_I_ID(ProvParser.BaseField.DATASET_I_ID, new ProvParser.LongValParser()),
        PARENT_I_ID(ProvParser.BaseField.PARENT_I_ID, new ProvParser.LongValParser()),
        FILE_I_ID(ProvParser.BaseField.INODE_ID, new ProvParser.LongValParser()),
        FILE_NAME(ProvParser.BaseField.INODE_NAME, new ProvParser.StringValParser()),
        PROJECT_NAME(ProvParser.AuxField.PROJECT_NAME, new ProvParser.StringValParser()),
        USER_ID(ProvParser.BaseField.USER_ID, new ProvParser.IntValParser()),
        APP_ID(ProvParser.BaseField.APP_ID, new ProvParser.StringValParser()),
        ML_TYPE(ProvParser.BaseField.ML_TYPE, new ProvParser.MLTypeValParser()),
        ML_ID(ProvParser.BaseField.ML_ID, new ProvParser.StringValParser()),
        PARTITION_ID(ProvParser.AuxField.PARTITION_ID, new ProvParser.LongValParser()),
        CREATE_TIMESTAMP(BaseField.CREATE_TIMESTAMP, new ProvParser.LongValParser()),
        R_CREATE_TIMESTAMP(BaseField.R_CREATE_TIMESTAMP, new ProvParser.StringValParser()),
        ENTRY_TYPE(ProvParser.BaseField.ENTRY_TYPE, new ProvParser.StringValParser());

        ProvParser.ElasticField elasticField;
        ProvParser.ValParser<?> filterValParser;

        private State(ProvParser.ElasticField elasticField, ProvParser.ValParser<?> filterValParser) {
            this.elasticField = elasticField;
            this.filterValParser = filterValParser;
        }

        @Override
        public String elasticFieldName() {
            return this.elasticField.toString().toLowerCase();
        }

        @Override
        public String queryFieldName() {
            return this.name().toLowerCase();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return ProvParser.FilterType.EXACT;
        }

        public ProvParser.ValParser filterValParser() {
            return this.filterValParser;
        }
    }

    public static enum BaseField implements ProvParser.ElasticField
    {
        CREATE_TIMESTAMP,
        R_CREATE_TIMESTAMP;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

