/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.common.jobs.spark.SparkJobConfiguration;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Converter
public class JupyterConfigurationConverter
implements AttributeConverter<JobConfiguration, String> {
    private static final Logger LOGGER = Logger.getLogger(JupyterConfigurationConverter.class.getName());
    private static JAXBContext jobJAXBContext;

    public String convertToDatabaseColumn(JobConfiguration config) {
        if (config == null) {
            config = new SparkJobConfiguration();
        }
        try {
            Marshaller marshaller = jobJAXBContext.createMarshaller();
            marshaller.setProperty("eclipselink.json.include-root", (Object)false);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)config, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public JobConfiguration convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            return this.unmarshal(jsonConfig, jobJAXBContext);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private JobConfiguration unmarshal(String jsonConfig, JAXBContext jaxbContext) throws JAXBException {
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StreamSource json = new StreamSource(new StringReader(jsonConfig));
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        return (JobConfiguration)unmarshaller.unmarshal((Source)json, SparkJobConfiguration.class).getValue();
    }

    static {
        try {
            jobJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{SparkJobConfiguration.class}, null);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "An error occurred while initializing JAXBContext", e);
        }
    }
}

