/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.elastic;

import io.hops.hopsworks.common.provenance.core.elastic.BasicElasticHit;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHitParser;
import io.hops.hopsworks.common.provenance.util.functional.CheckedConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.elasticsearch.search.SearchHit;

public class ElasticHitsHandler<R, S, A, E extends Exception> {
    private final S state;
    private final ElasticHitParser<R, E> parser;
    private final BiConsumer<R, S> stateBatchMerger;
    private final Optional<CheckedConsumer<S, E>> batchAction;

    public ElasticHitsHandler(S state, ElasticHitParser<R, E> parser, BiConsumer<R, S> stateBatchMerger, Optional<CheckedConsumer<S, E>> batchAction) {
        this.state = state;
        this.parser = parser;
        this.stateBatchMerger = stateBatchMerger;
        this.batchAction = batchAction;
    }

    public static <R, E extends Exception> ElasticHitsHandler<R, List<R>, ?, E> instanceAddToList(ElasticHitParser<R, E> parser) {
        return new ElasticHitsHandler(new ArrayList(), parser, (item, state) -> state.add(item), Optional.empty());
    }

    public static <R, S, E extends Exception> ElasticHitsHandler<R, S, ?, E> instanceBasic(S state, ElasticHitParser<R, E> parser, BiConsumer<R, S> stateBatchMerger) {
        return new ElasticHitsHandler(state, parser, stateBatchMerger, Optional.empty());
    }

    public static <R, S, A, E extends Exception> ElasticHitsHandler<R, S, ?, E> instanceWithAction(S state, ElasticHitParser<R, E> parser, BiConsumer<R, S> stateBatchMerger, CheckedConsumer<S, E> batchAction) {
        return new ElasticHitsHandler<R, S, A, E>(state, parser, stateBatchMerger, Optional.of(batchAction));
    }

    public void apply(SearchHit[] searchHits) throws E {
        for (SearchHit hit : searchHits) {
            Object item = this.parser.apply(BasicElasticHit.instance(hit));
            this.stateBatchMerger.accept(item, this.state);
        }
        if (this.batchAction.isPresent()) {
            this.batchAction.get().accept(this.state);
        }
    }

    public S get() {
        return this.state;
    }
}

