/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.security.secrets;

import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.security.secrets.Secret;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretId;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class SecretsFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager entityManager;

    public Secret findById(SecretId id) {
        return (Secret)this.entityManager.find(Secret.class, (Object)id);
    }

    public void persist(Secret secret) {
        this.entityManager.persist((Object)secret);
    }

    public void update(Secret secret) {
        this.entityManager.merge((Object)secret);
    }

    public List<Secret> findAllForUser(Users user) {
        return this.entityManager.createNamedQuery("Secret.findByUser", Secret.class).setParameter("uid", (Object)user.getUid()).getResultList();
    }

    public List<Secret> findAll() {
        return this.entityManager.createNamedQuery("Secret.findAll", Secret.class).getResultList();
    }

    public void deleteSecret(SecretId id) {
        Secret secret = this.findById(id);
        if (secret != null) {
            this.entityManager.remove((Object)secret);
        }
    }

    public void deleteSecretsForUser(Users user) {
        List<Secret> secrets = this.findAllForUser(user);
        for (Secret secret : secrets) {
            this.entityManager.remove((Object)secret);
        }
    }
}

