/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.util.Ip;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"Settings"})
public class ElasticClient {
    @EJB
    private Settings settings;
    @EJB
    private BaseHadoopClientsService clientsService;
    private static final Logger LOG = Logger.getLogger(ElasticClient.class.getName());
    private RestHighLevelClient elasticClient = null;

    @PostConstruct
    private void init() {
        try {
            this.getClient();
        }
        catch (ElasticException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @PreDestroy
    private void close() {
        try {
            this.shutdownClient();
        }
        catch (ElasticException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public synchronized RestHighLevelClient getClient() throws ElasticException {
        if (this.elasticClient == null) {
            HttpHost[] elasticAddrs = this.getElasticIps();
            boolean isSecurityEnabled = this.settings.isElasticOpenDistroSecurityEnabled();
            SSLContext sslCtx = null;
            BasicCredentialsProvider credentialsProvider = null;
            if (isSecurityEnabled) {
                Path trustStore = Paths.get(this.clientsService.getSuperTrustStorePath(), new String[0]);
                char[] trustStorePassword = this.clientsService.getSuperTrustStorePassword().toCharArray();
                try {
                    sslCtx = SSLContexts.custom().loadTrustMaterial(trustStore.toFile(), trustStorePassword).build();
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_CONNECTION_ERROR, Level.INFO, "Error while setting up connections to elasticsearch", e.getMessage(), (Throwable)e);
                }
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.settings.getElasticAdminUser(), this.settings.getElasticAdminPassword()));
            }
            SSLContext finalSslCtx = sslCtx;
            BasicCredentialsProvider finalCredentialsProvider = credentialsProvider;
            this.elasticClient = new RestHighLevelClient(RestClient.builder((HttpHost[])elasticAddrs).setHttpClientConfigCallback(httpAsyncClientBuilder -> {
                httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(5).build());
                if (isSecurityEnabled) {
                    return httpAsyncClientBuilder.setSSLContext(finalSslCtx).setDefaultCredentialsProvider(finalCredentialsProvider).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                }
                return httpAsyncClientBuilder;
            }));
        }
        return this.elasticClient;
    }

    private HttpHost[] getElasticIps() throws ElasticException {
        boolean isHTTPS = this.settings.isElasticHTTPSEnabled();
        List<String> addrs = this.settings.getElasticIps();
        HttpHost[] hosts = new HttpHost[addrs.size()];
        int index = 0;
        for (String addr : addrs) {
            if (!Ip.validIp(addr)) {
                try {
                    InetAddress.getByName(addr);
                }
                catch (UnknownHostException e) {
                    throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_CONNECTION_ERROR, Level.INFO, "Error while parsing elasticsearch ips", e.getMessage(), (Throwable)e);
                }
            }
            hosts[index] = new HttpHost(addr, this.settings.getElasticRESTPort(), isHTTPS ? "https" : "http");
            ++index;
        }
        return hosts;
    }

    public void shutdownClient() throws ElasticException {
        if (this.elasticClient != null) {
            try {
                this.elasticClient.indices().clearCache(new ClearIndicesCacheRequest(new String[]{"projects"}), RequestOptions.DEFAULT);
                this.elasticClient.close();
                this.elasticClient = null;
            }
            catch (IOException e) {
                throw new ElasticException(RESTCodes.ElasticErrorCode.ELASTIC_INTERNAL_REQ_ERROR, Level.INFO, "Error while shuting down client", e.getMessage(), (Throwable)e);
            }
        }
    }
}

