/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDataset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class TrainingDatasetFacade
extends AbstractFacade<TrainingDataset> {
    private static final Logger LOGGER = Logger.getLogger(TrainingDatasetFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public TrainingDatasetFacade() {
        super(TrainingDataset.class);
    }

    public TrainingDataset findById(Integer id) {
        try {
            return (TrainingDataset)this.em.createNamedQuery("TrainingDataset.findById", TrainingDataset.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public TrainingDataset findByIdAndFeaturestore(Integer id, Featurestore featurestore) {
        try {
            return (TrainingDataset)this.em.createNamedQuery("TrainingDataset.findByFeaturestoreAndId", TrainingDataset.class).setParameter("featurestore", (Object)featurestore).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<TrainingDataset> findAll() {
        TypedQuery q = this.em.createNamedQuery("TrainingDataset.findAll", TrainingDataset.class);
        return q.getResultList();
    }

    public List<TrainingDataset> findByFeaturestore(Featurestore featurestore) {
        TypedQuery q = this.em.createNamedQuery("TrainingDataset.findByFeaturestore", TrainingDataset.class).setParameter("featurestore", (Object)featurestore);
        return q.getResultList();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(TrainingDataset trainingDataset) {
        try {
            this.em.persist((Object)trainingDataset);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new TrainingDataset", cve);
        }
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public TrainingDataset updateTrainingDatasetMetadata(TrainingDataset trainingDataset) {
        this.em.merge((Object)trainingDataset);
        return trainingDataset;
    }
}

