/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.serving;

import io.hops.hopsworks.common.dao.kafka.ProjectTopics;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.serving.ServingType;
import io.hops.hopsworks.common.dao.user.Users;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="serving", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Serving.findAll", query="SELECT t FROM Serving t"), @NamedQuery(name="Serving.findById", query="SELECT t FROM Serving t WHERE t.id = :id"), @NamedQuery(name="Serving.findByProject", query="SELECT t FROM Serving t WHERE t.project = :project"), @NamedQuery(name="Serving.findByProjectAndId", query="SELECT t FROM Serving t WHERE t.project = :project AND t.id = :id"), @NamedQuery(name="Serving.findByCreated", query="SELECT t FROM Serving t WHERE t.created = :created"), @NamedQuery(name="Serving.findLocalhostRunning", query="SELECT t FROM Serving t WHERE t.localPid != -2"), @NamedQuery(name="Serving.expiredLocks", query="SELECT t FROM Serving t WHERE t.lockTimestamp is not NULL AND t.lockTimestamp < :lockts"), @NamedQuery(name="Serving.findByProjectAndName", query="SELECT t FROM Serving t WHERE t.name = :name AND t.project = :project")})
public class Serving
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @JoinColumn(name="creator", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users creator;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="artifact_path")
    private String artifactPath;
    @Basic(optional=false)
    @NotNull
    @Column(name="version")
    private Integer version;
    @Basic(optional=false)
    @NotNull
    @Column(name="optimized")
    private boolean optimized;
    @Column(name="instances")
    private Integer instances;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project project;
    @Column(name="enable_batching")
    private Boolean batchingEnabled;
    @Column(name="lock_ip")
    private String lockIP;
    @Column(name="lock_timestamp")
    private Long lockTimestamp;
    @JoinColumn(name="kafka_topic_id", referencedColumnName="id")
    @ManyToOne
    private ProjectTopics kafkaTopic;
    @Basic(optional=true)
    @Column(name="local_port")
    private Integer localPort;
    @Basic(optional=true)
    @Column(name="local_pid")
    private Integer localPid;
    @Basic(optional=true)
    @Column(name="local_dir")
    private String localDir;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="serving_type")
    private ServingType servingType = ServingType.TENSORFLOW;

    public Serving() {
    }

    public Serving(Integer id, String name, String artifactPath, Integer version, Integer nInstances, Boolean batchingEnabled, ServingType servingType) {
        this.id = id;
        this.name = name;
        this.artifactPath = artifactPath;
        this.version = version;
        this.instances = nInstances;
        this.batchingEnabled = batchingEnabled;
        this.servingType = servingType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public void setArtifactPath(String artifactPath) {
        this.artifactPath = artifactPath;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getInstances() {
        return this.instances;
    }

    public void setInstances(Integer instances) {
        this.instances = instances;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public Integer getLocalPid() {
        return this.localPid;
    }

    public void setLocalPid(Integer localPid) {
        this.localPid = localPid;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }

    public Boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public void setBatchingEnabled(Boolean batching) {
        this.batchingEnabled = batching;
    }

    public String getLockIP() {
        return this.lockIP;
    }

    public void setLockIP(String lockIP) {
        this.lockIP = lockIP;
    }

    public Long getLockTimestamp() {
        return this.lockTimestamp;
    }

    public void setLockTimestamp(Long lockTimestamp) {
        this.lockTimestamp = lockTimestamp;
    }

    public ProjectTopics getKafkaTopic() {
        return this.kafkaTopic;
    }

    public void setKafkaTopic(ProjectTopics kafkaTopic) {
        this.kafkaTopic = kafkaTopic;
    }

    public ServingType getServingType() {
        return this.servingType;
    }

    public void setServingType(ServingType servingType) {
        this.servingType = servingType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Serving serving = (Serving)o;
        if (this.optimized != serving.optimized) {
            return false;
        }
        if (this.batchingEnabled != serving.batchingEnabled) {
            return false;
        }
        if (this.id != null ? !this.id.equals(serving.id) : serving.id != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(serving.created) : serving.created != null) {
            return false;
        }
        if (this.creator != null ? !this.creator.equals(serving.creator) : serving.creator != null) {
            return false;
        }
        if (!this.name.equals(serving.name)) {
            return false;
        }
        if (!this.artifactPath.equals(serving.artifactPath)) {
            return false;
        }
        if (!this.version.equals(serving.version)) {
            return false;
        }
        if (this.instances != null ? !this.instances.equals(serving.instances) : serving.instances != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(serving.project) : serving.project != null) {
            return false;
        }
        if (this.lockIP != null ? !this.lockIP.equals(serving.lockIP) : serving.lockIP != null) {
            return false;
        }
        if (this.lockTimestamp != null ? !this.lockTimestamp.equals(serving.lockTimestamp) : serving.lockTimestamp != null) {
            return false;
        }
        if (this.kafkaTopic != null ? !this.kafkaTopic.equals(serving.kafkaTopic) : serving.kafkaTopic != null) {
            return false;
        }
        if (this.localPort != null ? !this.localPort.equals(serving.localPort) : serving.localPort != null) {
            return false;
        }
        if (this.localPid != null ? !this.localPid.equals(serving.localPid) : serving.localPid != null) {
            return false;
        }
        if (this.servingType != null ? !this.servingType.equals((Object)serving.servingType) : serving.servingType != null) {
            return false;
        }
        return this.localDir != null ? this.localDir.equals(serving.localDir) : serving.localDir == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.creator != null ? this.creator.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.artifactPath.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.optimized ? 1 : 0);
        result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 31 * result + (this.batchingEnabled != false ? 1 : 0);
        result = 31 * result + (this.lockIP != null ? this.lockIP.hashCode() : 0);
        result = 31 * result + (this.lockTimestamp != null ? this.lockTimestamp.hashCode() : 0);
        result = 31 * result + (this.kafkaTopic != null ? this.kafkaTopic.hashCode() : 0);
        result = 31 * result + (this.localPort != null ? this.localPort.hashCode() : 0);
        result = 31 * result + (this.localPid != null ? this.localPid.hashCode() : 0);
        result = 31 * result + (this.localDir != null ? this.localDir.hashCode() : 0);
        result = 31 * result + (this.servingType != null ? this.servingType.hashCode() : 0);
        return result;
    }
}

