/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.kafka.SharedTopics;
import io.hops.hopsworks.common.dao.kafka.SharedTopicsPK;
import io.hops.hopsworks.common.dao.project.Project;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class SharedTopicsFacade
extends AbstractFacade<SharedTopics> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public SharedTopicsFacade() {
        super(SharedTopics.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<SharedTopics> findSharedTopicsByProject(Integer projectId) {
        return this.em.createNamedQuery("SharedTopics.findByProjectId", SharedTopics.class).setParameter("projectId", (Object)projectId).getResultList();
    }

    public List<SharedTopics> findSharedTopicsByTopicName(String topicName) {
        return this.em.createNamedQuery("SharedTopics.findByTopicName", SharedTopics.class).setParameter("topicName", (Object)topicName).getResultList();
    }

    public Optional<SharedTopics> findSharedTopicByProjectAndTopic(Integer projectId, String topicName) {
        return Optional.ofNullable(this.em.find(SharedTopics.class, (Object)new SharedTopicsPK(topicName, projectId)));
    }

    public List<SharedTopics> findSharedTopicsByTopicAndOwnerProject(String topicName, Integer ownerProjectId) {
        return this.em.createNamedQuery("SharedTopics.findByTopicAndOwnerProjectId", SharedTopics.class).setParameter("topicName", (Object)topicName).setParameter("ownerProjectId", (Object)ownerProjectId).getResultList();
    }

    public void shareTopic(Project owningProject, String topicName, Integer projectId) {
        SharedTopics st = new SharedTopics(topicName, owningProject.getId(), projectId);
        this.em.persist((Object)st);
        this.em.flush();
    }

    public Optional<SharedTopics> findSharedTopicByTopicAndProjectIds(String topicName, Integer ownerProjectId, Integer destProjectId) {
        try {
            return Optional.ofNullable(this.em.createNamedQuery("SharedTopics.findByTopicAndProjectsIds", SharedTopics.class).setParameter("topicName", (Object)topicName).setParameter("ownerProjectId", (Object)ownerProjectId).setParameter("destProjectId", (Object)destProjectId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }
}

