/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.featuregroup;

import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.common.dao.featurestore.jobs.FeaturestoreJob;
import io.hops.hopsworks.common.dao.featurestore.statistics.FeaturestoreStatistic;
import io.hops.hopsworks.common.dao.featurestore.statistics.columns.StatisticColumn;
import io.hops.hopsworks.common.dao.user.Users;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="feature_group", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Featuregroup.findAll", query="SELECT fg FROM Featuregroup fg"), @NamedQuery(name="Featuregroup.findById", query="SELECT fg FROM Featuregroup fg WHERE fg.id = :id"), @NamedQuery(name="Featuregroup.findByFeaturestore", query="SELECT fg FROM Featuregroup fg WHERE fg.featurestore = :featurestore"), @NamedQuery(name="Featuregroup.findByFeaturestoreAndId", query="SELECT fg FROM Featuregroup fg WHERE fg.featurestore = :featurestore AND fg.id = :id")})
public class Featuregroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="feature_store_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Featurestore featurestore;
    @Basic(optional=false)
    @NotNull
    @Column(name="hdfs_user_id")
    private Integer hdfsUserId;
    @Basic(optional=false)
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @JoinColumn(name="creator", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users creator;
    @Basic(optional=false)
    @NotNull
    @Column(name="version")
    private Integer version;
    @Basic(optional=false)
    @NotNull
    @Column(name="desc_stats_enabled")
    private boolean descStatsEnabled = true;
    @Basic(optional=false)
    @NotNull
    @Column(name="feat_corr_enabled")
    private boolean featCorrEnabled = true;
    @Basic(optional=false)
    @NotNull
    @Column(name="feat_hist_enabled")
    private boolean featHistEnabled = true;
    @Basic(optional=false)
    @NotNull
    @Column(name="cluster_analysis_enabled")
    private boolean clusterAnalysisEnabled = true;
    @Basic(optional=false)
    @NotNull
    @Column(name="num_bins")
    private Integer numBins = 5;
    @Basic(optional=false)
    @NotNull
    @Column(name="num_clusters")
    private Integer numClusters = 20;
    @Basic(optional=false)
    @NotNull
    @Column(name="corr_method")
    private String corrMethod = "pearson";
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="featuregroup")
    private Collection<FeaturestoreStatistic> statistics;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="feature_group_type")
    private FeaturegroupType featuregroupType = FeaturegroupType.CACHED_FEATURE_GROUP;
    @JoinColumn(name="on_demand_feature_group_id", referencedColumnName="id")
    @OneToOne
    private OnDemandFeaturegroup onDemandFeaturegroup;
    @JoinColumn(name="cached_feature_group_id", referencedColumnName="id")
    @OneToOne
    private CachedFeaturegroup cachedFeaturegroup;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="featuregroup")
    private Collection<FeaturestoreJob> jobs;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="featuregroup")
    private Collection<StatisticColumn> statisticColumns;

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Featurestore getFeaturestore() {
        return this.featurestore;
    }

    public void setFeaturestore(Featurestore featurestore) {
        this.featurestore = featurestore;
    }

    public Integer getHdfsUserId() {
        return this.hdfsUserId;
    }

    public void setHdfsUserId(Integer hdfsUserId) {
        this.hdfsUserId = hdfsUserId;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean isDescStatsEnabled() {
        return this.descStatsEnabled;
    }

    public void setDescStatsEnabled(boolean descStatsEnabled) {
        this.descStatsEnabled = descStatsEnabled;
    }

    public boolean isFeatCorrEnabled() {
        return this.featCorrEnabled;
    }

    public void setFeatCorrEnabled(boolean featCorrEnabled) {
        this.featCorrEnabled = featCorrEnabled;
    }

    public boolean isFeatHistEnabled() {
        return this.featHistEnabled;
    }

    public void setFeatHistEnabled(boolean featHistEnabled) {
        this.featHistEnabled = featHistEnabled;
    }

    public boolean isClusterAnalysisEnabled() {
        return this.clusterAnalysisEnabled;
    }

    public void setClusterAnalysisEnabled(boolean clusterAnalysisEnabled) {
        this.clusterAnalysisEnabled = clusterAnalysisEnabled;
    }

    public Integer getNumBins() {
        return this.numBins;
    }

    public void setNumBins(Integer numBins) {
        this.numBins = numBins;
    }

    public Integer getNumClusters() {
        return this.numClusters;
    }

    public void setNumClusters(Integer numClusters) {
        this.numClusters = numClusters;
    }

    public String getCorrMethod() {
        return this.corrMethod;
    }

    public void setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
    }

    public Collection<FeaturestoreStatistic> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Collection<FeaturestoreStatistic> statistics) {
        this.statistics = statistics;
    }

    public FeaturegroupType getFeaturegroupType() {
        return this.featuregroupType;
    }

    public void setFeaturegroupType(FeaturegroupType featuregroupType) {
        this.featuregroupType = featuregroupType;
    }

    public OnDemandFeaturegroup getOnDemandFeaturegroup() {
        return this.onDemandFeaturegroup;
    }

    public void setOnDemandFeaturegroup(OnDemandFeaturegroup onDemandFeaturegroup) {
        this.onDemandFeaturegroup = onDemandFeaturegroup;
    }

    public CachedFeaturegroup getCachedFeaturegroup() {
        return this.cachedFeaturegroup;
    }

    public void setCachedFeaturegroup(CachedFeaturegroup cachedFeaturegroup) {
        this.cachedFeaturegroup = cachedFeaturegroup;
    }

    public Collection<FeaturestoreJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(Collection<FeaturestoreJob> jobs) {
        this.jobs = jobs;
    }

    public Collection<StatisticColumn> getStatisticColumns() {
        return this.statisticColumns;
    }

    public void setStatisticColumns(Collection<StatisticColumn> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Featuregroup that = (Featuregroup)o;
        if (this.descStatsEnabled != that.descStatsEnabled) {
            return false;
        }
        if (this.featCorrEnabled != that.featCorrEnabled) {
            return false;
        }
        if (this.featHistEnabled != that.featHistEnabled) {
            return false;
        }
        if (this.clusterAnalysisEnabled != that.clusterAnalysisEnabled) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (!this.featurestore.equals(that.featurestore)) {
            return false;
        }
        if (!this.hdfsUserId.equals(that.hdfsUserId)) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (!this.creator.equals(that.creator)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (!this.numBins.equals(that.numBins)) {
            return false;
        }
        if (!this.numClusters.equals(that.numClusters)) {
            return false;
        }
        if (!this.corrMethod.equals(that.corrMethod)) {
            return false;
        }
        if (!this.statistics.equals(that.statistics)) {
            return false;
        }
        if (this.featuregroupType != that.featuregroupType) {
            return false;
        }
        if (!this.onDemandFeaturegroup.equals(that.onDemandFeaturegroup)) {
            return false;
        }
        if (!this.cachedFeaturegroup.equals(that.cachedFeaturegroup)) {
            return false;
        }
        if (!this.jobs.equals(that.jobs)) {
            return false;
        }
        return this.statisticColumns.equals(that.statisticColumns);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.featurestore.hashCode();
        result = 31 * result + this.hdfsUserId.hashCode();
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + this.creator.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.descStatsEnabled ? 1 : 0);
        result = 31 * result + (this.featCorrEnabled ? 1 : 0);
        result = 31 * result + (this.featHistEnabled ? 1 : 0);
        result = 31 * result + (this.clusterAnalysisEnabled ? 1 : 0);
        result = 31 * result + this.numBins.hashCode();
        result = 31 * result + this.numClusters.hashCode();
        result = 31 * result + this.corrMethod.hashCode();
        result = 31 * result + this.statistics.hashCode();
        result = 31 * result + (this.featuregroupType != null ? this.featuregroupType.hashCode() : 0);
        result = 31 * result + this.onDemandFeaturegroup.hashCode();
        result = 31 * result + this.cachedFeaturegroup.hashCode();
        result = 31 * result + this.jobs.hashCode();
        result = 31 * result + this.statisticColumns.hashCode();
        return result;
    }
}

