/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jwt;

import io.hops.hopsworks.jwt.JWTController;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Startup
@Singleton
public class OneTimeJWTRotation {
    private static final Logger LOGGER = Logger.getLogger(OneTimeJWTRotation.class.getName());
    private static final long TIMER_INTERVAL = 86400000L;
    @EJB
    private JWTController jWTController;
    @Resource
    TimerService timerService;

    @PostConstruct
    private void init() {
        this.timerService.createTimer(0L, 86400000L, (Serializable)((Object)"Mark"));
    }

    @PreDestroy
    private void destroyTimer() {
        for (Timer timer : this.timerService.getTimers()) {
            timer.cancel();
        }
    }

    private void markAndSetTimer() {
        boolean marked = this.jWTController.markOldSigningKeys();
        if (marked) {
            long duration = 240000L;
            TimerConfig config = new TimerConfig();
            config.setInfo((Serializable)((Object)"Remove"));
            this.timerService.createSingleActionTimer(duration, config);
        }
    }

    @Timeout
    public void performTimeout(Timer timer) {
        String name = (String)((Object)timer.getInfo());
        if ("Mark".equals(name)) {
            this.markAndSetTimer();
        } else {
            this.jWTController.removeMarkedKeys();
        }
        LOGGER.log(Level.INFO, "{0} timer event: {1}.", new Object[]{timer.getInfo(), new Date()});
    }
}

