/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.remote;

import io.hops.hopsworks.common.dao.remote.oauth.OauthClient;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class OpenIdProviderConfig
implements Serializable {
    private JsonObject document;
    private String issuerURI;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String revocationEndpoint;
    private String jwkSetURI;
    private String registrationEndpointURI;
    private Set<String> responseTypesSupported;
    private Set<String> scopesSupported;
    private Set<String> claimsSupported;
    private Set<String> idTokenSigningAlgorithmsSupported;
    private Set<String> idTokenEncryptionAlgorithmsSupported;
    private Set<String> idTokenEncryptionMethodsSupported;
    private Set<String> subjectTypesSupported;

    public OpenIdProviderConfig(JsonObject document) {
        this.document = document;
        this.issuerURI = this.getStrOrNull(document, "issuer");
        this.authorizationEndpoint = this.getStrOrNull(document, "authorization_endpoint");
        this.tokenEndpoint = this.getStrOrNull(document, "token_endpoint");
        this.userInfoEndpoint = this.getStrOrNull(document, "userinfo_endpoint");
        this.revocationEndpoint = this.getStrOrNull(document, "revocation_endpoint");
        this.registrationEndpointURI = this.getStrOrNull(document, "registration_endpoint");
        this.jwkSetURI = this.getStrOrNull(document, "jwks_uri");
        this.scopesSupported = this.getValues("scopes_supported");
        this.claimsSupported = this.getValues("claims_supported");
        this.responseTypesSupported = this.getValues("response_types_supported");
        this.idTokenSigningAlgorithmsSupported = this.getValues("id_token_signing_alg_values_supported");
        this.idTokenEncryptionAlgorithmsSupported = this.getValues("id_token_encryption_alg_values_supported");
        this.idTokenEncryptionMethodsSupported = this.getValues("id_token_encryption_enc_values_supported");
        this.subjectTypesSupported = this.getValues("subject_types_supported");
    }

    public OpenIdProviderConfig(OauthClient client) {
        this.issuerURI = client.getProviderURI();
        this.authorizationEndpoint = client.getAuthorisationEndpoint();
        this.tokenEndpoint = client.getTokenEndpoint();
        this.userInfoEndpoint = client.getUserInfoEndpoint();
    }

    public String getIssuerURI() {
        return this.issuerURI;
    }

    public void setIssuerURI(String issuerURI) {
        this.issuerURI = issuerURI;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public String getJwkSetURI() {
        return this.jwkSetURI;
    }

    public void setJwkSetURI(String jwkSetURI) {
        this.jwkSetURI = jwkSetURI;
    }

    public String getRegistrationEndpointURI() {
        return this.registrationEndpointURI;
    }

    public void setRegistrationEndpointURI(String registrationEndpointURI) {
        this.registrationEndpointURI = registrationEndpointURI;
    }

    public JsonObject getDocument() {
        return this.document;
    }

    public void setDocument(JsonObject document) {
        this.document = document;
    }

    public Set<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public void setResponseTypesSupported(Set<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public Set<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public void setScopesSupported(Set<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    public Set<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    public void setClaimsSupported(Set<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public Set<String> getIdTokenSigningAlgorithmsSupported() {
        return this.idTokenSigningAlgorithmsSupported;
    }

    public void setIdTokenSigningAlgorithmsSupported(Set<String> idTokenSigningAlgorithmsSupported) {
        this.idTokenSigningAlgorithmsSupported = idTokenSigningAlgorithmsSupported;
    }

    public Set<String> getIdTokenEncryptionAlgorithmsSupported() {
        return this.idTokenEncryptionAlgorithmsSupported;
    }

    public void setIdTokenEncryptionAlgorithmsSupported(Set<String> idTokenEncryptionAlgorithmsSupported) {
        this.idTokenEncryptionAlgorithmsSupported = idTokenEncryptionAlgorithmsSupported;
    }

    public Set<String> getIdTokenEncryptionMethodsSupported() {
        return this.idTokenEncryptionMethodsSupported;
    }

    public void setIdTokenEncryptionMethodsSupported(Set<String> idTokenEncryptionMethodsSupported) {
        this.idTokenEncryptionMethodsSupported = idTokenEncryptionMethodsSupported;
    }

    public Set<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(Set<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    private String getStrOrNull(JsonObject jsonObj, String key) {
        if (jsonObj.containsKey((Object)key)) {
            return jsonObj.getString(key);
        }
        return null;
    }

    private Set<String> getValues(String key) {
        JsonArray jsonArray = this.document.getJsonArray(key);
        if (Objects.isNull(jsonArray)) {
            return Collections.emptySet();
        }
        return jsonArray.stream().filter(element -> element.getValueType() == JsonValue.ValueType.STRING).map(element -> (JsonString)element).map(JsonString::getString).collect(Collectors.toSet());
    }

    public String toString() {
        return "OpenIdProviderConfig{document=" + this.document + ", issuerURI='" + this.issuerURI + '\'' + ", authorizationEndpoint='" + this.authorizationEndpoint + '\'' + ", tokenEndpoint='" + this.tokenEndpoint + '\'' + ", userInfoEndpoint='" + this.userInfoEndpoint + '\'' + ", revocationEndpoint='" + this.revocationEndpoint + '\'' + ", jwkSetURI='" + this.jwkSetURI + '\'' + ", registrationEndpointURI='" + this.registrationEndpointURI + '\'' + ", responseTypesSupported=" + this.responseTypesSupported + ", scopesSupported=" + this.scopesSupported + ", claimsSupported=" + this.claimsSupported + ", idTokenSigningAlgorithmsSupported=" + this.idTokenSigningAlgorithmsSupported + ", idTokenEncryptionAlgorithmsSupported=" + this.idTokenEncryptionAlgorithmsSupported + ", idTokenEncryptionMethodsSupported=" + this.idTokenEncryptionMethodsSupported + ", subjectTypesSupported=" + this.subjectTypesSupported + '}';
    }
}

