/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter.config;

import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jupyter.JupyterProject;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.util.Settings;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class JupyterFacade {
    private static final Logger logger = Logger.getLogger(JupyterFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public boolean remove(String hdfsUsername, int port) {
        if (hdfsUsername == null || hdfsUsername.isEmpty()) {
            return false;
        }
        JupyterProject jp = this.findByUserAndPort(hdfsUsername, port);
        if (jp == null) {
            return false;
        }
        try {
            this.em.remove((Object)jp);
            this.em.flush();
        }
        catch (Exception ex) {
            logger.warning("Problem removing jupyter notebook entry from hopsworks DB");
            logger.warning(ex.getMessage());
            return false;
        }
        return true;
    }

    public JupyterProject findByUserAndPort(String hdfsUser, int port) {
        HdfsUsers res = null;
        TypedQuery query = this.em.createNamedQuery("HdfsUsers.findByName", HdfsUsers.class);
        query.setParameter("name", (Object)hdfsUser);
        try {
            res = (HdfsUsers)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        TypedQuery jupyterProjectQuery = this.em.createNamedQuery("JupyterProject.findByHdfsUserIdAndPort", JupyterProject.class);
        jupyterProjectQuery.setParameter("hdfsUserId", (Object)res.getId());
        jupyterProjectQuery.setParameter("port", (Object)port);
        try {
            return (JupyterProject)jupyterProjectQuery.getSingleResult();
        }
        catch (NoResultException e) {
            Logger.getLogger(JupyterFacade.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    public JupyterProject findByUser(String hdfsUser) {
        HdfsUsers res = null;
        TypedQuery hdfsUsersQuery = this.em.createNamedQuery("HdfsUsers.findByName", HdfsUsers.class);
        hdfsUsersQuery.setParameter("name", (Object)hdfsUser);
        try {
            res = (HdfsUsers)hdfsUsersQuery.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        TypedQuery jupyterProjectQuery = this.em.createNamedQuery("JupyterProject.findByHdfsUserId", JupyterProject.class);
        jupyterProjectQuery.setParameter("hdfsUserId", (Object)res.getId());
        try {
            return (JupyterProject)jupyterProjectQuery.getSingleResult();
        }
        catch (NoResultException e) {
            Logger.getLogger(JupyterFacade.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    public List<JupyterProject> getAllNotebookServers() {
        List res = null;
        TypedQuery query = this.em.createNamedQuery("JupyterProject.findAll", JupyterProject.class);
        try {
            res = query.getResultList();
        }
        catch (EntityNotFoundException | NoResultException e) {
            Logger.getLogger(JupyterFacade.class.getName()).log(Level.FINE, null, e);
            return null;
        }
        return res;
    }

    public JupyterProject saveServer(String host, Project project, String secretConfig, int port, int hdfsUserId, String token, long pid, Date expires) {
        JupyterProject jp = new JupyterProject(project, secretConfig, port, hdfsUserId, host, token, pid, expires);
        this.persist(jp);
        return jp;
    }

    private void persist(JupyterProject jp) {
        if (jp != null) {
            this.em.persist((Object)jp);
        }
    }

    public void update(JupyterProject jp) {
        if (jp != null) {
            this.em.merge((Object)jp);
        }
    }

    public String getProjectPath(JupyterProject jp, String projectName, String hdfsUser) {
        return this.settings.getJupyterDir() + File.separator + "Projects" + File.separator + projectName + File.separator + hdfsUser + File.separator + jp.getSecret();
    }
}

