/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.rstudio;

import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.rstudio.RStudioSettingsPK;
import io.hops.hopsworks.common.dao.user.Users;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="rstudio_settings", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="RStudioSettings.findAll", query="SELECT j FROM RStudioSettings j"), @NamedQuery(name="RStudioSettings.findByProjectId", query="SELECT j FROM RStudioSettings j WHERE j.rstudioSettingsPK.projectId = :projectId"), @NamedQuery(name="RStudioSettings.findByTeamMember", query="SELECT j FROM RStudioSettings j WHERE j.rstudioSettingsPK.email = :email"), @NamedQuery(name="RStudioSettings.findByNumTfPs", query="SELECT j FROM RStudioSettings j WHERE j.numTfPs = :numTfPs"), @NamedQuery(name="RStudioSettings.findByNumTfGpus", query="SELECT j FROM RStudioSettings j WHERE j.numTfGpus = :numTfGpus"), @NamedQuery(name="RStudioSettings.findByNumMpiNp", query="SELECT j FROM RStudioSettings j WHERE j.numMpiNp = :numMpiNp"), @NamedQuery(name="RStudioSettings.findByAppmasterCores", query="SELECT j FROM RStudioSettings j WHERE j.appmasterCores = :appmasterCores"), @NamedQuery(name="RStudioSettings.findByAppmasterMemory", query="SELECT j FROM RStudioSettings j WHERE j.appmasterMemory = :appmasterMemory"), @NamedQuery(name="RStudioSettings.findByNumExecutors", query="SELECT j FROM RStudioSettings j WHERE j.numExecutors = :numExecutors"), @NamedQuery(name="RStudioSettings.findByNumExecutorCores", query="SELECT j FROM RStudioSettings j WHERE j.numExecutorCores = :numExecutorCores"), @NamedQuery(name="RStudioSettings.findByExecutorMemory", query="SELECT j FROM RStudioSettings j WHERE j.executorMemory = :executorMemory"), @NamedQuery(name="RStudioSettings.findByDynamicInitialExecutors", query="SELECT j FROM RStudioSettings j WHERE j.dynamicInitialExecutors = :dynamicInitialExecutors"), @NamedQuery(name="RStudioSettings.findByDynamicMinExecutors", query="SELECT j FROM RStudioSettings j WHERE j.dynamicMinExecutors = :dynamicMinExecutors"), @NamedQuery(name="RStudioSettings.findByDynamicMaxExecutors", query="SELECT j FROM RStudioSettings j WHERE j.dynamicMaxExecutors = :dynamicMaxExecutors"), @NamedQuery(name="RStudioSettings.findBySecret", query="SELECT j FROM RStudioSettings j WHERE j.secret = :secret"), @NamedQuery(name="RStudioSettings.findByLogLevel", query="SELECT j FROM RStudioSettings j WHERE j.logLevel = :logLevel"), @NamedQuery(name="RStudioSettings.findByMode", query="SELECT j FROM RStudioSettings j WHERE j.mode = :mode"), @NamedQuery(name="RStudioSettings.findByAdvanced", query="SELECT j FROM RStudioSettings j WHERE j.advanced = :advanced"), @NamedQuery(name="RStudioSettings.findByArchives", query="SELECT j FROM RStudioSettings j WHERE j.archives = :archives"), @NamedQuery(name="RStudioSettings.findByJars", query="SELECT j FROM RStudioSettings j WHERE j.jars = :jars"), @NamedQuery(name="RStudioSettings.findByFiles", query="SELECT j FROM RStudioSettings j WHERE j.files = :files"), @NamedQuery(name="RStudioSettings.findByPyFiles", query="SELECT j FROM RStudioSettings j WHERE j.pyFiles = :pyFiles"), @NamedQuery(name="RStudioSettings.findBySparkParams", query="SELECT j FROM RStudioSettings j WHERE j.sparkParams = :sparkParams"), @NamedQuery(name="RStudioSettings.findByUmask", query="SELECT j FROM RStudioSettings j WHERE j.umask = :umask")})
public class RStudioSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected RStudioSettingsPK rstudioSettingsPK;
    @Basic(optional=false)
    @Column(name="num_tf_ps")
    private int numTfPs = 1;
    @Basic(optional=false)
    @Column(name="num_tf_gpus")
    private int numTfGpus = 0;
    @Basic(optional=false)
    @Column(name="num_mpi_np")
    private int numMpiNp = 1;
    @Basic(optional=false)
    @Column(name="appmaster_cores")
    private int appmasterCores = 1;
    @Basic(optional=false)
    @Column(name="appmaster_memory")
    private int appmasterMemory = 1024;
    @Basic(optional=false)
    @Column(name="num_executors")
    private int numExecutors = 1;
    @Basic(optional=false)
    @Column(name="num_executor_cores")
    private int numExecutorCores = 1;
    @Basic(optional=false)
    @Column(name="executor_memory")
    private int executorMemory = 4096;
    @Basic(optional=false)
    @Column(name="dynamic_initial_executors")
    private int dynamicInitialExecutors = 1;
    @Basic(optional=false)
    @Column(name="dynamic_min_executors")
    private int dynamicMinExecutors = 1;
    @Basic(optional=false)
    @Column(name="dynamic_max_executors")
    private int dynamicMaxExecutors = 100;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="secret")
    private String secret;
    @Size(max=32)
    @Column(name="log_level")
    private String logLevel = "INFO";
    @Basic(optional=false)
    @Column(name="shutdown_level")
    private int shutdownLevel = 1;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=32)
    @Column(name="mode")
    private String mode = "dynamicSpark";
    @Basic(optional=false)
    @Column(name="advanced")
    private boolean advanced = false;
    @Basic(optional=false)
    @Size(min=0, max=1500)
    @Column(name="archives")
    private String archives = "";
    @Basic(optional=false)
    @Size(min=0, max=1500)
    @Column(name="jars")
    private String jars = "";
    @Basic(optional=false)
    @Size(min=0, max=1500)
    @Column(name="files")
    private String files = "";
    @Basic(optional=false)
    @Size(min=0, max=1500)
    @Column(name="py_files")
    private String pyFiles = "";
    @Basic(optional=false)
    @Size(min=0, max=6500)
    @Column(name="spark_params")
    private String sparkParams = "";
    @Basic(optional=false)
    @Size(min=3, max=4)
    @Column(name="umask")
    private String umask = "022";
    @JoinColumn(name="team_member", referencedColumnName="email", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Users users;
    @JoinColumn(name="project_id", referencedColumnName="id", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Project project;
    @Transient
    private String privateDir = "";
    @Transient
    private String baseDir = "/Jupyter/";

    public RStudioSettings() {
    }

    public RStudioSettings(RStudioSettingsPK rstudioSettingsPK) {
        this.rstudioSettingsPK = rstudioSettingsPK;
    }

    public RStudioSettings(RStudioSettingsPK rstudioSettingsPK, int numTfPs, int numTfGpus, int numMpiNp, int appmasterCores, int appmasterMemory, int numExecutors, int numExecutorCores, int executorMemory, int dynamicInitialExecutors, int dynamicMinExecutors, int dynamicMaxExecutors, String secret, String mode, boolean advanced, String archives, String jars, String files, String pyFiles, String sparkParams, String umask) {
        this.rstudioSettingsPK = rstudioSettingsPK;
        this.numTfPs = numTfPs;
        this.numTfGpus = numTfGpus;
        this.numMpiNp = numMpiNp;
        this.appmasterCores = appmasterCores;
        this.appmasterMemory = appmasterMemory;
        this.numExecutors = numExecutors;
        this.numExecutorCores = numExecutorCores;
        this.executorMemory = executorMemory;
        this.dynamicInitialExecutors = dynamicInitialExecutors;
        this.dynamicMinExecutors = dynamicMinExecutors;
        this.dynamicMaxExecutors = dynamicMaxExecutors;
        this.secret = secret;
        this.mode = mode;
        this.advanced = advanced;
        this.archives = archives;
        this.jars = jars;
        this.files = files;
        this.pyFiles = pyFiles;
        this.sparkParams = sparkParams;
        this.umask = umask;
    }

    public RStudioSettings(int projectId, String email) {
        this.rstudioSettingsPK = new RStudioSettingsPK(projectId, email);
    }

    public RStudioSettingsPK getRStudioSettingsPK() {
        return this.rstudioSettingsPK;
    }

    public void setRStudioSettingsPK(RStudioSettingsPK rstudioSettingsPK) {
        this.rstudioSettingsPK = rstudioSettingsPK;
    }

    public int getNumTfPs() {
        return this.numTfPs;
    }

    public void setNumTfPs(int numTfPs) {
        this.numTfPs = numTfPs;
    }

    public int getNumTfGpus() {
        return this.numTfGpus;
    }

    public void setNumTfGpus(int numTfGpus) {
        this.numTfGpus = numTfGpus;
    }

    public int getNumMpiNp() {
        return this.numMpiNp;
    }

    public void setNumMpiNp(int numMpiNp) {
        this.numMpiNp = numMpiNp;
    }

    public int getAppmasterCores() {
        return this.appmasterCores;
    }

    public void setAppmasterCores(int appmasterCores) {
        this.appmasterCores = appmasterCores;
    }

    public int getAppmasterMemory() {
        return this.appmasterMemory;
    }

    public void setAppmasterMemory(int appmasterMemory) {
        this.appmasterMemory = appmasterMemory;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors;
    }

    public int getNumExecutorCores() {
        return this.numExecutorCores;
    }

    public void setNumExecutorCores(int numExecutorCores) {
        this.numExecutorCores = numExecutorCores;
    }

    public int getExecutorMemory() {
        return this.executorMemory;
    }

    public void setExecutorMemory(int executorMemory) {
        this.executorMemory = executorMemory;
    }

    public int getDynamicInitialExecutors() {
        return this.dynamicInitialExecutors;
    }

    public void setDynamicInitialExecutors(int dynamicInitialExecutors) {
        this.dynamicInitialExecutors = dynamicInitialExecutors;
    }

    public int getDynamicMinExecutors() {
        return this.dynamicMinExecutors;
    }

    public void setDynamicMinExecutors(int dynamicMinExecutors) {
        this.dynamicMinExecutors = dynamicMinExecutors;
    }

    public int getDynamicMaxExecutors() {
        return this.dynamicMaxExecutors;
    }

    public void setDynamicMaxExecutors(int dynamicMaxExecutors) {
        this.dynamicMaxExecutors = dynamicMaxExecutors;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean getAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public String getArchives() {
        return this.archives;
    }

    public void setArchives(String archives) {
        this.archives = archives;
    }

    public String getJars() {
        return this.jars;
    }

    public void setJars(String jars) {
        this.jars = jars;
    }

    public String getFiles() {
        return this.files;
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public String getPyFiles() {
        return this.pyFiles;
    }

    public void setPyFiles(String pyFiles) {
        this.pyFiles = pyFiles;
    }

    public String getSparkParams() {
        return this.sparkParams;
    }

    public void setSparkParams(String sparkParams) {
        this.sparkParams = sparkParams;
    }

    public String getUmask() {
        return this.umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public Users getUsers() {
        return this.users;
    }

    public void setUsers(Users users) {
        this.users = users;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.rstudioSettingsPK != null ? this.rstudioSettingsPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RStudioSettings)) {
            return false;
        }
        RStudioSettings other = (RStudioSettings)object;
        return (this.rstudioSettingsPK != null || other.rstudioSettingsPK == null) && (this.rstudioSettingsPK == null || this.rstudioSettingsPK.equals(other.rstudioSettingsPK));
    }

    public String toString() {
        return "io.hops.hopsworks.common.dao.jupyter.RStudioSettings[ rstudioSettingsPK=" + this.rstudioSettingsPK + " ]";
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getPrivateDir() {
        return this.privateDir;
    }

    public void setPrivateDir(String privateDir) {
        this.privateDir = privateDir;
    }

    public int getShutdownLevel() {
        return this.shutdownLevel;
    }

    public void setShutdownLevel(int shutdownLevel) {
        this.shutdownLevel = shutdownLevel;
    }
}

