/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security.utils;

import io.hops.hopsworks.common.security.utils.Secret;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class SecurityUtils {
    private static final Logger LOGGER = Logger.getLogger(SecurityUtils.class.getName());
    private final int RANDOM_KEY_LEN = 64;
    private final int RANDOM_PREFIX_KEY_LEN = 16;
    public static final long RESET_LINK_VALID_FOR_HOUR = 24L;
    private SecureRandom secureRandom;

    @PostConstruct
    public void init() {
        this.secureRandom = new SecureRandom();
    }

    public String calculateSecretKey() {
        byte[] encodedKey = this.calculateSecretKey(10);
        return new String(encodedKey);
    }

    public byte[] calculateSecretKey(int length) {
        byte[] bytes = new byte[length];
        this.secureRandom.nextBytes(bytes);
        Base32 codec = new Base32();
        return codec.encode(bytes);
    }

    public String generateSecureRandomString(int length) {
        byte[] encoded = this.generateSecureRandom(length);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public String generateSecureRandomString() {
        return this.generateSecureRandomString(64);
    }

    public byte[] generateSecureRandom(int length) {
        byte[] bytes = new byte[length];
        this.secureRandom.nextBytes(bytes);
        byte[] encoded = Base64.getEncoder().encode(bytes);
        return encoded;
    }

    public String generateRandomString(int length) {
        return RandomStringUtils.random((int)length, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.secureRandom);
    }

    public Secret generateSecret() {
        String id = this.generateRandomString(16);
        String key = this.generateRandomString(64);
        String salt = this.generateSecureRandomString(64);
        Secret secret = new Secret(id, key, salt, 16, 64, 64);
        return secret;
    }

    public Secret generateSecret(String password) {
        String salt = this.generateSecureRandomString(64);
        Secret secret = new Secret(password, salt, 6, 64);
        return secret;
    }

    public String urlEncode(String key) {
        String urlEncoded;
        try {
            urlEncoded = URLEncoder.encode(key, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return urlEncoded;
    }

    public String getHash(String val) {
        return DigestUtils.sha256Hex((String)val);
    }
}

