/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.ndb;

import io.hops.hopsworks.common.dao.ndb.NdbBackup;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class NdbBackupFacade
implements Serializable {
    private static final Logger logger = Logger.getLogger(NdbBackupFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public NdbBackup find(Integer id) {
        return (NdbBackup)this.em.find(NdbBackup.class, (Object)id);
    }

    public List<NdbBackup> findAll() {
        TypedQuery query = this.em.createNamedQuery("NdbBackup.findAll", NdbBackup.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void persistBackup(NdbBackup backup) {
        this.em.persist((Object)backup);
    }

    public void removeBackup(int id) {
        NdbBackup backup = this.find(id);
        if (backup != null) {
            this.em.remove((Object)backup);
        }
    }

    public NdbBackup findHighestBackupId() {
        TypedQuery query = this.em.createNamedQuery("NdbBackup.findHighestBackupId", NdbBackup.class);
        try {
            return (NdbBackup)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

