/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.agent;

import com.google.gson.Gson;
import io.hops.hopsworks.common.agent.AgentLivenessMonitor;
import io.hops.hopsworks.common.dao.command.HeartbeatReplyDTO;
import io.hops.hopsworks.common.dao.command.SystemCommand;
import io.hops.hopsworks.common.dao.command.SystemCommandFacade;
import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.host.Status;
import io.hops.hopsworks.common.dao.kagent.HostServicesFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.AnacondaRepo;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.dao.python.CondaCommands;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.dao.python.PythonDep;
import io.hops.hopsworks.common.hosts.HostsController;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.environment.EnvironmentController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AgentController {
    private static final Logger LOG = Logger.getLogger(AgentController.class.getName());
    private static final Comparator ASC_COMPARATOR = new CommandsComparator();
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private Settings settings;
    @EJB
    private HostServicesFacade hostServicesFacade;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private LibraryFacade libraryFacade;
    @EJB
    private LibraryController libraryController;
    @EJB
    private EnvironmentController environmentController;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private SystemCommandFacade systemCommandFacade;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private AgentLivenessMonitor agentLivenessMonitor;
    @EJB
    private HostsController hostsController;

    public String register(String hostId, String password) throws ServiceException {
        Hosts host = this.hostsController.findByHostname(hostId);
        host.setAgentPassword(password);
        host.setRegistered(true);
        host.setHostname(hostId);
        this.hostsFacade.update(host);
        return this.settings.getHadoopVersionedDir();
    }

    public HeartbeatReplyDTO heartbeat(AgentHeartbeatDTO heartbeat) throws ServiceException {
        Hosts host = this.hostsController.findByHostname(heartbeat.hostId);
        if (!host.getRegistered().booleanValue()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.HOST_NOT_REGISTERED, Level.WARNING, "hostId: " + heartbeat.hostId);
        }
        this.agentLivenessMonitor.alive(host);
        this.updateHostMetrics(host, heartbeat);
        this.updateServices(heartbeat);
        this.processCondaCommands(heartbeat);
        this.processSystemCommands(heartbeat);
        if (heartbeat.condaReport != null && !heartbeat.condaReport.isEmpty()) {
            this.issueCondaEnvsGCCommand(host, heartbeat.condaReport);
        }
        if (heartbeat.recover != null && heartbeat.recover.booleanValue()) {
            this.recoverUnfinishedCommands(host);
        }
        HeartbeatReplyDTO response = new HeartbeatReplyDTO();
        this.addNewCommandsToResponse(host, response);
        return response;
    }

    private void issueCondaEnvsGCCommand(Hosts host, List<String> envsToCheck) {
        List envsToDelete = envsToCheck.stream().filter(p -> {
            Project project = this.projectFacade.findByName((String)p);
            return project == null || project.getCondaEnv() == false || project.getConda() == false;
        }).collect(Collectors.toList());
        String projectNamesStr = new Gson().toJson(envsToDelete);
        SystemCommand gcCommand = new SystemCommand(host, SystemCommandFacade.OP.CONDA_GC);
        gcCommand.setPriority(Integer.MIN_VALUE);
        gcCommand.setExecUser(this.settings.getAnacondaUser());
        gcCommand.setCommandArgumentsAsString(projectNamesStr);
        this.systemCommandFacade.persist(gcCommand);
    }

    private void recoverUnfinishedCommands(Hosts host) {
        this.recoverCondaCommands(host);
        this.recoverSystemCommands(host);
    }

    private void recoverCondaCommands(Hosts host) {
        List<CondaCommands> allUnfinished = this.condaCommandFacade.findUnfinishedByHost(host);
        for (CondaCommands command : allUnfinished) {
            try {
                this.commandsController.updateCondaCommandStatus(command.getId(), CondaCommandFacade.CondaStatus.NEW, command.getArg());
            }
            catch (ServiceException ex) {
                LOG.log(Level.WARNING, "Could not recover command with ID: " + command.getId() + " for host " + host);
            }
        }
    }

    private void recoverSystemCommands(Hosts host) {
        List<SystemCommand> allUnfinished = this.systemCommandFacade.findUnfinishedByHost(host);
        for (SystemCommand command : allUnfinished) {
            command.setStatus(SystemCommandFacade.STATUS.NEW);
            this.systemCommandFacade.update(command);
        }
    }

    private void addNewCommandsToResponse(Hosts host, HeartbeatReplyDTO response) {
        ArrayList<CondaCommands> newCondaCommands = new ArrayList<CondaCommands>();
        List<CondaCommands> allCondaCommands = this.condaCommandFacade.findByHost(host);
        for (CondaCommands cc : allCondaCommands) {
            if (!cc.getStatus().equals((Object)CondaCommandFacade.CondaStatus.NEW)) continue;
            newCondaCommands.add(cc);
            cc.setHostId(host);
        }
        ArrayList<SystemCommand> newSystemCommands = new ArrayList<SystemCommand>();
        List<SystemCommand> allSystemCommands = this.systemCommandFacade.findByHost(host);
        for (SystemCommand sc : allSystemCommands) {
            if (!sc.getStatus().equals((Object)SystemCommandFacade.STATUS.NEW)) continue;
            newSystemCommands.add(sc);
        }
        newCondaCommands.sort(ASC_COMPARATOR);
        newSystemCommands.sort(ASC_COMPARATOR);
        response.setCondaCommands(newCondaCommands);
        response.setSystemCommands(newSystemCommands);
    }

    private void updateHostMetrics(Hosts host, AgentHeartbeatDTO heartbeat) throws ServiceException {
        host.setLastHeartbeat(new Date().getTime());
        host.setNumGpus(heartbeat.numGpus);
        host.setPrivateIp(heartbeat.privateIp);
        host.setCores(heartbeat.cores);
        host.setMemoryCapacity(heartbeat.memoryCapacity);
        this.hostsFacade.update(host);
    }

    private void updateServices(AgentHeartbeatDTO heartbeat) throws ServiceException {
        this.hostServicesFacade.updateHostServices(heartbeat);
    }

    private void processCondaCommands(AgentHeartbeatDTO heartbeatDTO) throws ServiceException {
        if (heartbeatDTO.condaCommands == null) {
            return;
        }
        for (CondaCommands cc : heartbeatDTO.condaCommands) {
            Project projectId;
            String projectName = cc.getProj();
            CondaCommandFacade.CondaOp opType = cc.getOp();
            String channelUrl = cc.getChannelUrl();
            String lib = cc.getLib() != null ? cc.getLib() : "";
            String version = cc.getVersion() != null ? cc.getVersion() : "";
            String args = cc.getArg() != null ? cc.getArg() : "";
            CondaCommandFacade.CondaStatus status = cc.getStatus();
            Integer commandId = cc.getId();
            CondaCommands command = this.condaCommandFacade.findCondaCommand(commandId);
            if (command == null) continue;
            this.commandsController.updateCondaCommandStatus(commandId, status, command.getInstallType(), command.getMachineType(), args, projectName, command.getUserId(), opType, lib, version, channelUrl);
            if (command.getOp().equals((Object)CondaCommandFacade.CondaOp.YML) && this.settings.getHopsworksIp().equals(command.getHostId().getHostIp()) && (status.equals((Object)CondaCommandFacade.CondaStatus.SUCCESS) || status.equals((Object)CondaCommandFacade.CondaStatus.FAILED))) {
                projectId = command.getProjectId();
                String envStr = this.listCondaEnvironment(projectName);
                Collection<PythonDep> pythonDeps = this.synchronizeDependencies(envStr, projectId.getPythonDepCollection());
                this.libraryController.addPythonDepsForProject(projectId, pythonDeps);
            }
            if (command.getOp().equals((Object)CondaCommandFacade.CondaOp.EXPORT) && status.equals((Object)CondaCommandFacade.CondaStatus.SUCCESS)) {
                this.environmentController.uploadYmlInProject(command.getProjectId(), command.getUserId(), cc.getEnvironmentYml(), command.getArg());
            }
            if (!command.getOp().equals((Object)CondaCommandFacade.CondaOp.UPGRADE)) continue;
            command.setVersion(this.getLocalLibraryVersion(command.getLib(), command.getVersion(), projectName));
            if (!this.settings.getHopsworksIp().equals(command.getHostId().getHostIp())) continue;
            projectId = command.getProjectId();
            block1: for (PythonDep pythonDep : projectId.getPythonDepCollection()) {
                String localVersion;
                if (!pythonDep.getDependency().equals(command.getLib()) || !pythonDep.getVersion().equals(command.getVersion()) || (localVersion = this.getLocalLibraryVersion(command.getLib(), command.getVersion(), projectName)).equals(command.getVersion())) continue;
                Collection<PythonDep> deps = projectId.getPythonDepCollection();
                for (PythonDep dep : deps) {
                    if (!dep.getDependency().equals(command.getLib())) continue;
                    PythonDep newDep = this.libraryFacade.getOrCreateDep(dep.getRepoUrl(), dep.getMachineType(), command.getInstallType(), command.getLib(), localVersion, true, false);
                    deps.remove(dep);
                    deps.add(newDep);
                    this.projectFacade.update(projectId);
                    continue block1;
                }
            }
        }
    }

    public String listCondaEnvironment(String project) {
        String prog = this.settings.getHopsworksDomainDir() + "/bin/list_environment.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(prog).addCommand(project).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.processExited()) {
                return processResult.getStdout();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Problem listing conda environment: {0}", ex.toString());
        }
        return "";
    }

    public Collection<PythonDep> synchronizeDependencies(String condaListStr, Collection<PythonDep> currentlyInstalledPyDeps) throws ServiceException {
        ArrayList<PythonDep> deps = new ArrayList<PythonDep>();
        String[] lines = condaListStr.split(System.getProperty("line.separator"));
        Optional<String> cpuHost = this.hostsFacade.findCPUHost();
        Optional<String> gpuHost = this.hostsFacade.findGPUHost();
        for (int i = 3; i < lines.length; ++i) {
            PythonDep pyDep2;
            AnacondaRepo repo;
            String line = lines[i];
            String[] split = line.split(" +");
            String libraryName = split[0];
            String version = split[1];
            if (this.settings.getPreinstalledPythonLibraryNames().contains(libraryName)) {
                repo = this.libraryFacade.getRepo("PyPi", true);
                pyDep2 = this.libraryFacade.getOrCreateDep(repo, LibraryFacade.MachineType.ALL, CondaCommandFacade.CondaInstallType.PIP, libraryName, version, true, true);
                deps.add(pyDep2);
                continue;
            }
            if (libraryName.equals("tensorflow") || libraryName.equals("tensorflow-gpu") || libraryName.equals("tensorflow-rocm")) {
                repo = this.libraryFacade.getRepo("PyPi", true);
                if (cpuHost.isPresent()) {
                    PythonDep tensorflowCPU = this.libraryFacade.getOrCreateDep(repo, LibraryFacade.MachineType.CPU, CondaCommandFacade.CondaInstallType.PIP, "tensorflow", version, true, true);
                    deps.add(tensorflowCPU);
                }
                if (!gpuHost.isPresent()) continue;
                PythonDep tensorflowCudaGPU = this.libraryFacade.getOrCreateDep(repo, LibraryFacade.MachineType.GPU, CondaCommandFacade.CondaInstallType.PIP, "tensorflow-gpu", version, true, true);
                deps.add(tensorflowCudaGPU);
                PythonDep tensorflowROCmGPU = this.libraryFacade.getOrCreateDep(repo, LibraryFacade.MachineType.GPU, CondaCommandFacade.CondaInstallType.PIP, "tensorflow-rocm", version, true, true);
                deps.add(tensorflowROCmGPU);
                continue;
            }
            if (this.settings.getProvidedPythonLibraryNames().contains(libraryName)) {
                repo = this.libraryFacade.getRepo("PyPi", true);
                pyDep2 = this.libraryFacade.getOrCreateDep(repo, LibraryFacade.MachineType.ALL, CondaCommandFacade.CondaInstallType.PIP, libraryName, version, true, false);
                deps.add(pyDep2);
                continue;
            }
            for (PythonDep pyDep2 : currentlyInstalledPyDeps) {
                if (!libraryName.equals(pyDep2.getDependency())) continue;
                pyDep2.setVersion(split[1]);
                deps.add(pyDep2);
            }
        }
        return deps;
    }

    private String getLocalLibraryVersion(String library, String currentVersion, String projName) {
        String condaListStr = this.listCondaEnvironment(projName);
        String[] lines = condaListStr.split(System.getProperty("line.separator"));
        for (int i = 3; i < lines.length; ++i) {
            String line = lines[i];
            String[] split = line.split(" +");
            String localLib = split[0];
            if (!localLib.equals(library)) continue;
            return split[1];
        }
        return currentVersion;
    }

    private void processSystemCommands(AgentHeartbeatDTO heartbeat) {
        if (heartbeat.systemCommands == null) {
            return;
        }
        for (SystemCommand sc : heartbeat.systemCommands) {
            Integer id = sc.getId();
            SystemCommandFacade.STATUS status = sc.getStatus();
            SystemCommand systemCommand = this.systemCommandFacade.findById(id);
            if (systemCommand == null) {
                throw new IllegalArgumentException("System command with ID: " + id + " is not in the system");
            }
            this.genericProcessSystemCommand(systemCommand, status);
        }
    }

    private void genericProcessSystemCommand(SystemCommand command, SystemCommandFacade.STATUS status) {
        if (status.equals((Object)SystemCommandFacade.STATUS.FINISHED)) {
            this.systemCommandFacade.delete(command);
        } else {
            command.setStatus(status);
            this.systemCommandFacade.update(command);
        }
    }

    private static class CommandsComparator<T>
    implements Comparator<T> {
        private CommandsComparator() {
        }

        @Override
        public int compare(T t, T t1) {
            if (t instanceof CondaCommands && t1 instanceof CondaCommands) {
                return this.condaCommandCompare((CondaCommands)t, (CondaCommands)t1);
            }
            if (t instanceof SystemCommand && t1 instanceof SystemCommand) {
                return this.systemCommandCompare((SystemCommand)t, (SystemCommand)t1);
            }
            return 0;
        }

        private int condaCommandCompare(CondaCommands t, CondaCommands t1) {
            if (t.getId() > t1.getId()) {
                return 1;
            }
            if (t.getId() < t1.getId()) {
                return -1;
            }
            return 0;
        }

        private int systemCommandCompare(SystemCommand t, SystemCommand t1) {
            if (t.getId() > t1.getId()) {
                return 1;
            }
            if (t.getId() < t1.getId()) {
                return -1;
            }
            return 0;
        }
    }

    public static class AgentServiceDTO {
        private final String service;
        private final String group;
        private final Integer pid;
        private final Status status;

        public AgentServiceDTO(String service, String group, Integer pid, Status status) {
            this.service = service;
            this.group = group;
            this.pid = pid;
            this.status = status;
        }

        public String getService() {
            return this.service;
        }

        public String getGroup() {
            return this.group;
        }

        public Integer getPid() {
            return this.pid;
        }

        public Status getStatus() {
            return this.status;
        }
    }

    public static class AgentHeartbeatDTO {
        private final String hostId;
        private final Long agentTime;
        private final Integer numGpus;
        private final Long memoryCapacity;
        private final Integer cores;
        private final String privateIp;
        private final List<AgentServiceDTO> services;
        private final List<SystemCommand> systemCommands;
        private final List<CondaCommands> condaCommands;
        private final List<String> condaReport;
        private final Boolean recover;

        public AgentHeartbeatDTO(String hostId, Long agentTime, Integer numGpus, Long memoryCapacity, Integer cores, String privateIp, List<AgentServiceDTO> services, List<SystemCommand> systemCommands, List<CondaCommands> condaCommands, List<String> condaReport, Boolean recover) {
            this.hostId = hostId;
            this.agentTime = agentTime;
            this.numGpus = numGpus;
            this.memoryCapacity = memoryCapacity;
            this.cores = cores;
            this.privateIp = privateIp;
            this.services = services;
            this.systemCommands = systemCommands;
            this.condaCommands = condaCommands;
            this.condaReport = condaReport;
            this.recover = recover;
        }

        public String getHostId() {
            return this.hostId;
        }

        public Long getAgentTime() {
            return this.agentTime;
        }

        public Integer getNumGpus() {
            return this.numGpus;
        }

        public Long getMemoryCapacity() {
            return this.memoryCapacity;
        }

        public Integer getCores() {
            return this.cores;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public List<AgentServiceDTO> getServices() {
            return this.services;
        }

        public List<SystemCommand> getSystemCommands() {
            return this.systemCommands;
        }

        public List<CondaCommands> getCondaCommands() {
            return this.condaCommands;
        }

        public Boolean getRecover() {
            return this.recover;
        }
    }
}

