/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.statistics;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.featurestore.statistics.FeaturestoreStatisticType;
import io.hops.hopsworks.common.dao.featurestore.statistics.FeaturestoreStatisticValue;
import io.hops.hopsworks.common.dao.featurestore.statistics.cluster_analysis.ClusterAnalysisDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.correlation.CorrelationValueDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.descriptive.DescriptiveStatsMetricValuesDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.distribution.FeatureDistributionDTO;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.json.JSONObject;

@Converter
public class FeaturestoreStatisticValueConverter
implements AttributeConverter<FeaturestoreStatisticValue, String> {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreStatisticValueConverter.class.getName());
    private static JAXBContext descriptiveStatsJAXBContext;
    private static JAXBContext featureCorrelationJAXBContext;
    private static JAXBContext featureHistogramsJAXBContext;
    private static JAXBContext clusterAnalysisJAXBContext;

    public String convertToDatabaseColumn(FeaturestoreStatisticValue featurestoreStatisticValue) {
        try {
            JAXBContext jc = this.getJAXBContext(featurestoreStatisticValue.getStatisticType());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("eclipselink.json.include-root", (Object)false);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)featurestoreStatisticValue, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public FeaturestoreStatisticValue convertToEntityAttribute(String featurestoreStatisticValueJsonStr) {
        if (Strings.isNullOrEmpty((String)featurestoreStatisticValueJsonStr)) {
            return null;
        }
        try {
            JSONObject featurestoreStatisticValueJsonObj = new JSONObject(featurestoreStatisticValueJsonStr);
            FeaturestoreStatisticType featurestoreStatisticType = FeaturestoreStatisticType.valueOf(((String)featurestoreStatisticValueJsonObj.get("statisticType")).toUpperCase());
            JAXBContext jc = this.getJAXBContext(featurestoreStatisticType);
            return this.unmarshal(featurestoreStatisticValueJsonStr, featurestoreStatisticType, jc);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private JAXBContext getJAXBContext(FeaturestoreStatisticType featurestoreStatisticType) {
        switch (featurestoreStatisticType) {
            case DESCRIPTIVESTATISTICS: {
                return descriptiveStatsJAXBContext;
            }
            case FEATURECORRELATIONS: {
                return featureCorrelationJAXBContext;
            }
            case FEATUREDISTRIBUTIONS: {
                return featureHistogramsJAXBContext;
            }
            case CLUSTERANALYSIS: {
                return clusterAnalysisJAXBContext;
            }
        }
        throw new IllegalArgumentException("Could not find a mapping for FeaturestoreStatisticType " + (Object)((Object)featurestoreStatisticType));
    }

    private FeaturestoreStatisticValue unmarshal(String featurestoreStatisticValueJson, FeaturestoreStatisticType featurestoreStatisticType, JAXBContext jaxbContext) throws JAXBException {
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StreamSource json = new StreamSource(new StringReader(featurestoreStatisticValueJson));
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        switch (featurestoreStatisticType) {
            case DESCRIPTIVESTATISTICS: {
                return (FeaturestoreStatisticValue)unmarshaller.unmarshal((Source)json, DescriptiveStatsMetricValuesDTO.class).getValue();
            }
            case FEATURECORRELATIONS: {
                return (FeaturestoreStatisticValue)unmarshaller.unmarshal((Source)json, CorrelationValueDTO.class).getValue();
            }
            case FEATUREDISTRIBUTIONS: {
                return (FeaturestoreStatisticValue)unmarshaller.unmarshal((Source)json, FeatureDistributionDTO.class).getValue();
            }
            case CLUSTERANALYSIS: {
                return (FeaturestoreStatisticValue)unmarshaller.unmarshal((Source)json, ClusterAnalysisDTO.class).getValue();
            }
        }
        throw new IllegalArgumentException("Could not find a mapping for featurestore statistic type " + (Object)((Object)featurestoreStatisticType));
    }

    static {
        try {
            descriptiveStatsJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{DescriptiveStatsMetricValuesDTO.class}, null);
            featureCorrelationJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{CorrelationValueDTO.class}, null);
            featureHistogramsJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{FeatureDistributionDTO.class}, null);
            clusterAnalysisJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{ClusterAnalysisDTO.class}, null);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "An error occurred while initializing JAXBContext", e);
        }
    }
}

