/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.tensorflow;

import io.hops.hopsworks.common.dao.jupyter.JupyterSettings;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.tensorflow.TensorBoardPK;
import io.hops.hopsworks.common.dao.user.Users;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="tensorboard", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="TensorBoard.findAll", query="SELECT t FROM TensorBoard t"), @NamedQuery(name="TensorBoard.findByProjectId", query="SELECT t FROM TensorBoard t WHERE t.tensorBoardPK.projectId = :projectId"), @NamedQuery(name="TensorBoard.findByUserId", query="SELECT t FROM TensorBoard t WHERE t.tensorBoardPK.userId = :userId"), @NamedQuery(name="TensorBoard.findByUserEmail", query="SELECT t FROM TensorBoard t WHERE t.users.email = :email"), @NamedQuery(name="TensorBoard.findByMlId", query="SELECT t FROM TensorBoard t WHERE t.mlId = :mlId"), @NamedQuery(name="TensorBoard.findByProjectAndUser", query="SELECT t FROM TensorBoard t WHERE t.tensorBoardPK.projectId = :projectId AND t.tensorBoardPK.userId = :userId")})
public class TensorBoard
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TensorBoardPK tensorBoardPK;
    @Basic(optional=false)
    @NotNull
    @Column(name="hdfs_user_id")
    private int hdfsUserId;
    @Column(name="pid")
    private BigInteger pid;
    @Size(min=1, max=100)
    @Column(name="endpoint")
    private String endpoint;
    @Size(min=1, max=100)
    @Column(name="ml_id")
    private String mlId;
    @Basic(optional=false)
    @NotNull
    @Column(name="last_accessed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastAccessed;
    @Size(min=1, max=10000)
    @Column(name="hdfs_logdir")
    private String hdfsLogdir;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="secret")
    private String secret;
    @JoinColumn(name="project_id", referencedColumnName="id", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Project project;
    @JoinColumn(name="user_id", referencedColumnName="uid", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Users users;

    public TensorBoard() {
    }

    public TensorBoard(TensorBoardPK tensorBoardPK) {
        this.setTensorBoardPK(tensorBoardPK);
    }

    public TensorBoard(TensorBoardPK tensorBoardPK, BigInteger pid, String endpoint, String mlId, Date lastAccessed, String hdfsLogdir, String secret, int hdfsUserId) {
        this.setTensorBoardPK(tensorBoardPK);
        this.setPid(pid);
        this.setEndpoint(endpoint);
        this.setMlId(mlId);
        this.setLastAccessed(lastAccessed);
        this.setHdfsLogdir(hdfsLogdir);
        this.setSecret(secret);
        this.setHdfsUserId(hdfsUserId);
    }

    public TensorBoardPK getTensorBoardPK() {
        return this.tensorBoardPK;
    }

    public void setTensorBoardPK(TensorBoardPK tensorBoardPK) {
        this.tensorBoardPK = tensorBoardPK;
    }

    public BigInteger getPid() {
        return this.pid;
    }

    public void setPid(BigInteger pid) {
        this.pid = pid;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Date getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(Date lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public String getHdfsLogdir() {
        return this.hdfsLogdir;
    }

    public void setHdfsLogdir(String hdfsLogdir) {
        this.hdfsLogdir = hdfsLogdir;
    }

    public int getHdfsUserId() {
        return this.hdfsUserId;
    }

    public void setHdfsUserId(int hdfsUserId) {
        this.hdfsUserId = hdfsUserId;
    }

    public String getMlId() {
        return this.mlId;
    }

    public void setMlId(String mlId) {
        this.mlId = mlId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Users getUsers() {
        return this.users;
    }

    public void setUsers(Users user) {
        this.users = user;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.tensorBoardPK != null ? this.tensorBoardPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JupyterSettings)) {
            return false;
        }
        TensorBoard other = (TensorBoard)object;
        return (this.tensorBoardPK != null || other.tensorBoardPK == null) && (this.tensorBoardPK == null || this.tensorBoardPK.equals(other.tensorBoardPK));
    }

    public String toString() {
        return "io.hops.hopsworks.common.dao.tensorflow.TensorBoard[ tensorBoardPK=" + this.tensorBoardPK + " ]";
    }
}

