/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.yarn;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.jobs.yarn.LogReader;
import io.hops.hopsworks.common.jobs.yarn.YarnMonitor;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;

public class YarnLogUtil {
    private static final Logger LOGGER = Logger.getLogger(YarnLogUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(DistributedFileSystemOps dfs, String dst, String message, Exception exception) {
        PrintStream writer = null;
        try {
            writer = new PrintStream((OutputStream)dfs.create(dst));
            if (exception != null) {
                writer.print(message + "\n" + exception.getMessage());
            } else {
                writer.print(message);
            }
        }
        catch (IOException ex) {
            if (writer != null) {
                writer.print(YarnLogUtil.class.getName() + ": Failed to write logs.\n" + ex.getMessage());
            }
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyAggregatedYarnLogs(DistributedFileSystemOps dfs, String src, String dst, String[] desiredLogTypes, YarnMonitor monitor) throws YarnException, IOException, InterruptedException {
        LogAggregationStatus logAggregationStatus = YarnLogUtil.waitForLogAggregation(monitor.getYarnClient(), monitor.getApplicationId());
        if (logAggregationStatus == null) {
            return;
        }
        PrintStream writer = null;
        try {
            String[] srcs = YarnLogUtil.getAggregatedLogFilePaths(src, dfs);
            if (!YarnLogUtil.logFilesReady(srcs, dfs)) {
                LOGGER.log(Level.SEVERE, "Error getting logs");
            }
            writer = new PrintStream((OutputStream)dfs.create(dst));
            switch (logAggregationStatus) {
                case FAILED: {
                    writer.print("The log aggregation failed");
                    return;
                }
                case TIME_OUT: {
                    writer.print("*** WARNING: Log aggregation has timed-out for some of the containers\n\n\n");
                    for (String desiredLogType : desiredLogTypes) {
                        YarnLogUtil.writeLogs(dfs, srcs, writer, desiredLogType);
                    }
                    return;
                }
                case SUCCEEDED: {
                    for (String desiredLogType : desiredLogTypes) {
                        YarnLogUtil.writeLogs(dfs, srcs, writer, desiredLogType);
                    }
                    return;
                }
                default: {
                    writer.print("Something went wrong during log aggregation phase! Log aggregation status is: " + logAggregationStatus.name());
                    return;
                }
            }
        }
        catch (Exception ex) {
            if (writer != null) {
                writer.print(YarnLogUtil.class.getName() + ": Failed to get aggregated logs.\n" + ex.getMessage());
            }
            LOGGER.log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    public static LogAggregationStatus waitForLogAggregation(YarnClient yarnClient, ApplicationId appId) throws InterruptedException, YarnException, IOException {
        LogAggregationStatus logAggregationStatus = yarnClient.getApplicationReport(appId).getLogAggregationStatus();
        int not_startRetries = 0;
        while (!YarnLogUtil.isFinal(logAggregationStatus)) {
            TimeUnit.SECONDS.sleep(1L);
            logAggregationStatus = yarnClient.getApplicationReport(appId).getLogAggregationStatus();
            if (!logAggregationStatus.equals((Object)LogAggregationStatus.NOT_START) || ++not_startRetries <= 5) continue;
            break;
        }
        return logAggregationStatus;
    }

    private static boolean isFinal(LogAggregationStatus status) {
        if (status == null) {
            return true;
        }
        switch (status) {
            case RUNNING: 
            case RUNNING_WITH_FAILURE: 
            case NOT_START: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeLogs(DistributedFileSystemOps dfs, String[] srcs, PrintStream writer, String desiredLogType) {
        ArrayList<AggregatedLogFormat.LogKey> containerNames = new ArrayList<AggregatedLogFormat.LogKey>();
        LogReader reader = null;
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        AggregatedLogFormat.ContainerLogsReader logReader = null;
        try {
            for (String src : srcs) {
                DataInputStream valueStream;
                Path location = new Path(src);
                LOGGER.log(Level.FINE, "Copying log from {0}", src);
                try {
                    reader = new LogReader(dfs.getConf(), dfs, location);
                    valueStream = reader.next(key);
                    while (valueStream != null) {
                        containerNames.add(key);
                        valueStream = reader.next(key);
                    }
                    reader.close();
                    reader = new LogReader(dfs.getConf(), dfs, location);
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.FINE, "Logs not available. Aggregation may have failed.");
                    if (reader == null) return;
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error getting logs");
                    if (reader == null) return;
                    reader.close();
                    return;
                }
                try {
                    for (AggregatedLogFormat.LogKey containerKey : containerNames) {
                        valueStream = reader.next(key);
                        while (valueStream != null && !key.equals((Object)containerKey)) {
                            valueStream = reader.next(key);
                        }
                        if (valueStream != null) {
                            logReader = new AggregatedLogFormat.ContainerLogsReader(valueStream);
                        }
                        if (logReader == null) continue;
                        YarnLogUtil.readContainerLogs(logReader, writer, desiredLogType, containerKey, location.getName());
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error getting logs");
                }
                containerNames.clear();
                key = new AggregatedLogFormat.LogKey();
                logReader = null;
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean logsReady(DistributedFileSystemOps dfs, String src) {
        DataInputStream valueStream;
        ArrayList<AggregatedLogFormat.LogKey> containerNames = new ArrayList<AggregatedLogFormat.LogKey>();
        LogReader reader = null;
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        AggregatedLogFormat.ContainerLogsReader logReader = null;
        try {
            try {
                reader = new LogReader(dfs.getConf(), dfs, new Path(src));
                valueStream = reader.next(key);
                while (valueStream != null) {
                    containerNames.add(key);
                    valueStream = reader.next(key);
                }
                reader.close();
                reader = new LogReader(dfs.getConf(), dfs, new Path(src));
            }
            catch (IOException e) {
                boolean bl = false;
                if (reader == null) return bl;
                reader.close();
                return bl;
            }
        }
        catch (Throwable throwable) {
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        for (AggregatedLogFormat.LogKey containerKey : containerNames) {
            valueStream = reader.next(key);
            while (valueStream != null && !key.equals((Object)containerKey)) {
                valueStream = reader.next(key);
            }
            if (valueStream != null) {
                logReader = new AggregatedLogFormat.ContainerLogsReader(valueStream);
            }
            if (logReader == null || YarnLogUtil.testLogs(logReader, "out")) continue;
            boolean bl = false;
            if (reader == null) return bl;
            reader.close();
            return bl;
        }
        {
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error testing logs");
            }
        }
        if (reader == null) return true;
        reader.close();
        return true;
    }

    private static boolean testLogs(AggregatedLogFormat.ContainerLogsReader logReader, String desiredLogType) throws IOException {
        boolean foundLog = true;
        String logType = logReader.nextLog();
        while (logType != null) {
            foundLog = true;
            if (!logType.contains(desiredLogType)) {
                foundLog = false;
            }
            logType = logReader.nextLog();
        }
        return foundLog;
    }

    private static boolean readContainerLogs(AggregatedLogFormat.ContainerLogsReader logReader, PrintStream writer, String desiredLogType, AggregatedLogFormat.LogKey containerKey, String nodename) throws IOException {
        int bufferSize = 65536;
        char[] cbuf = new char[bufferSize];
        boolean foundLog = false;
        String logType = logReader.nextLog();
        while (logType != null) {
            if (desiredLogType == null || desiredLogType.isEmpty() || logType.contains(desiredLogType)) {
                int currentToRead;
                long logLength = logReader.getCurrentLogLength();
                if (!foundLog) {
                    writer.append("Container: " + containerKey.toString() + " on " + nodename + "\n============================================================================================== \n");
                }
                if (logLength == 0L) {
                    writer.append("Log Type: " + logType + "\n");
                    writer.append("Log Length: 0\n");
                    logType = logReader.nextLog();
                    continue;
                }
                writer.append("Log Type: " + logType + "\n");
                writer.append("Log Length: " + Long.toString(logLength) + "\n");
                writer.append("Log Contents: \n");
                int len = 0;
                int n = currentToRead = logLength > (long)bufferSize ? bufferSize : (int)logLength;
                while (logLength > 0L && (len = logReader.read(cbuf, 0, currentToRead)) > 0) {
                    writer.append(new String(cbuf, 0, len));
                    currentToRead = (logLength -= (long)len) > (long)bufferSize ? bufferSize : (int)logLength;
                }
                writer.append("\n");
                foundLog = true;
            }
            logType = logReader.nextLog();
        }
        return foundLog;
    }

    private static String[] getAggregatedLogFilePaths(String path, DistributedFileSystemOps dfs) throws IOException {
        Path location = new Path(path);
        if (!dfs.exists(path)) {
            String[] paths = new String[]{path};
            return paths;
        }
        if (!dfs.isDir(path)) {
            String[] paths = new String[]{path};
            return paths;
        }
        FileStatus[] fileStatus = dfs.listStatus(location);
        if (fileStatus == null || fileStatus.length == 0) {
            String[] paths = new String[]{path};
            return paths;
        }
        String[] paths = new String[fileStatus.length];
        for (int i = 0; i < fileStatus.length; ++i) {
            paths[i] = path + File.separator + fileStatus[i].getPath().getName();
        }
        return paths;
    }

    private static boolean logFilesReady(String[] paths, DistributedFileSystemOps dfs) throws IOException {
        boolean ready = false;
        for (String path : paths) {
            Path location = new Path(path);
            if (!dfs.exists(path)) {
                return false;
            }
            if (dfs.isDir(path)) {
                return false;
            }
            FileStatus fileStatus = dfs.getFileStatus(location);
            if (fileStatus == null) {
                return false;
            }
            if (fileStatus.getLen() == 0L) {
                return false;
            }
            if (!YarnLogUtil.logsReady(dfs, path)) {
                return false;
            }
            ready = true;
        }
        return ready;
    }
}

