/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.project;

import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.hdfs.Utils;
import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class MoreInfoDTO {
    private Long inodeid;
    private String user;
    private double size;
    private Date createDate;
    private Date uploadDate;
    private int votes;
    private long downloads;
    private String path;

    public MoreInfoDTO() {
    }

    public MoreInfoDTO(Project proj) {
        this.inodeid = proj.getInode().getId();
        this.user = proj.getOwner().getFname() + " " + proj.getOwner().getFname();
        this.size = 0.0;
        this.createDate = proj.getCreated();
        this.uploadDate = null;
        this.path = Utils.getProjectPath(proj.getName());
    }

    public MoreInfoDTO(Inode inode) {
        this.inodeid = inode.getId();
        this.user = inode.getHdfsUser().getUsername();
        this.size = inode.getSize();
        this.createDate = new Date(inode.getModificationTime().longValue());
        this.uploadDate = null;
    }

    public MoreInfoDTO(Dataset ds, String user) {
        this.inodeid = ds.getInode().getId();
        this.user = user;
        this.size = ds.getInode().getSize();
        this.createDate = new Date(ds.getInode().getModificationTime().longValue());
        this.uploadDate = null;
    }

    public MoreInfoDTO(Long inodeid, String user, double size, Date createDate, Date uploadDate, int votes, long downloads) {
        this.inodeid = inodeid;
        this.user = user;
        this.size = size;
        this.createDate = createDate;
        this.uploadDate = uploadDate;
        this.votes = votes;
        this.downloads = downloads;
    }

    public String getUser() {
        return this.user;
    }

    public Long getInodeid() {
        return this.inodeid;
    }

    public void setInodeid(Long inodeid) {
        this.inodeid = inodeid;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    public void setUploadDate(Date uploadDate) {
        this.uploadDate = uploadDate;
    }

    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    public long getDownloads() {
        return this.downloads;
    }

    public void setDownloads(long downloads) {
        this.downloads = downloads;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.inodeid);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoreInfoDTO other = (MoreInfoDTO)obj;
        return Objects.equals(this.inodeid, other.inodeid);
    }

    public String toString() {
        return "MoreInfoDTO{inodeid=" + this.inodeid + ", user=" + this.user + ", size=" + this.size + ", createDate=" + this.createDate + ", uploadDate=" + this.uploadDate + ", votes=" + this.votes + ", downloads=" + this.downloads + '}';
    }
}

