/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state.dto;

import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateDTO;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.elastic.BasicElasticHit;
import io.hops.hopsworks.common.provenance.state.ProvSParser;
import io.hops.hopsworks.common.provenance.state.ProvTree;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProvStateElastic
implements Comparator<ProvStateElastic>,
ProvTree.State {
    private static final Logger LOGGER = Logger.getLogger(ProvStateElastic.class.getName());
    private String id;
    private float score;
    private Map<String, Object> map;
    private Long inodeId;
    private String appId;
    private Integer userId;
    private Long projectInodeId;
    private Long datasetInodeId;
    private String inodeName;
    private String projectName;
    private Provenance.MLType mlType;
    private String mlId;
    private Long createTime;
    private String readableCreateTime;
    private Map<String, String> xattrs = new HashMap<String, String>();
    private ProvAppStateDTO appState;
    private String fullPath;
    private Long partitionId;
    private Long parentInodeId;

    public static ProvStateElastic instance(BasicElasticHit hit) throws ProvenanceException {
        ProvStateElastic result = new ProvStateElastic();
        result.id = hit.getId();
        result.score = Float.isNaN(hit.getScore().floatValue()) ? 0.0f : hit.getScore().floatValue();
        result.map = hit.getSource();
        return ProvStateElastic.instance(result);
    }

    private static ProvStateElastic instance(ProvStateElastic result) throws ProvenanceException {
        HashMap<String, Object> auxMap = new HashMap<String, Object>(result.map);
        try {
            result.projectInodeId = (Long)ProvHelper.extractElasticField(auxMap, ProvSParser.State.PROJECT_I_ID);
            result.inodeId = (Long)ProvHelper.extractElasticField(auxMap, ProvSParser.State.FILE_I_ID);
            result.appId = (String)ProvHelper.extractElasticField(auxMap, ProvSParser.State.APP_ID);
            result.userId = (Integer)ProvHelper.extractElasticField(auxMap, ProvSParser.State.USER_ID);
            result.inodeName = (String)ProvHelper.extractElasticField(auxMap, ProvSParser.State.FILE_NAME);
            result.createTime = (Long)ProvHelper.extractElasticField(auxMap, ProvSParser.State.CREATE_TIMESTAMP);
            result.mlType = (Provenance.MLType)((Object)ProvHelper.extractElasticField(auxMap, ProvSParser.State.ML_TYPE));
            result.mlId = (String)ProvHelper.extractElasticField(auxMap, ProvSParser.State.ML_ID);
            result.datasetInodeId = (Long)ProvHelper.extractElasticField(auxMap, ProvSParser.State.DATASET_I_ID);
            result.parentInodeId = (Long)ProvHelper.extractElasticField(auxMap, ProvSParser.State.PARENT_I_ID);
            result.partitionId = (Long)ProvHelper.extractElasticField(auxMap, ProvSParser.State.PARTITION_ID);
            result.projectName = (String)ProvHelper.extractElasticField(auxMap, ProvSParser.State.PROJECT_NAME);
            result.readableCreateTime = (String)ProvHelper.extractElasticField(auxMap, ProvSParser.State.R_CREATE_TIMESTAMP);
            ProvHelper.extractElasticField(auxMap, ProvSParser.State.ENTRY_TYPE);
            result.xattrs = ProvHelper.extractElasticField(auxMap, ProvParser.XAttrField.XATTR_PROV, ProvHelper.asXAttrMap(), true);
            if (result.xattrs != null && result.xattrs.containsKey(ProvSParser.State.APP_ID.toString())) {
                result.appId = (String)ProvHelper.extractElasticField(result.xattrs.get(ProvParser.BaseField.APP_ID.toString()));
            }
            if (!auxMap.isEmpty()) {
                LOGGER.log(Level.FINE, "fields:{0} not managed in file state return", auxMap.keySet());
            }
        }
        catch (ClassCastException e) {
            String msg = "mismatch between DTO class and ProvSParser field types (elastic)";
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, msg, msg, (Throwable)e);
        }
        return result;
    }

    public float getScore() {
        return this.score;
    }

    @Override
    public int compare(ProvStateElastic o1, ProvStateElastic o2) {
        return Float.compare(o2.getScore(), o1.getScore());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getMap() {
        HashMap<String, String> refined = new HashMap<String, String>();
        if (this.map != null) {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                String value = entry.getValue() == null ? "null" : entry.getValue().toString();
                refined.put(entry.getKey(), value);
            }
        }
        return refined;
    }

    public void setMap(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public Long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(long inodeId) {
        this.inodeId = inodeId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Override
    public Long getProjectInodeId() {
        return this.projectInodeId;
    }

    public void setProjectInodeId(Long projectInodeId) {
        this.projectInodeId = projectInodeId;
    }

    public Long getDatasetInodeId() {
        return this.datasetInodeId;
    }

    public void setDatasetInodeId(Long datasetInodeId) {
        this.datasetInodeId = datasetInodeId;
    }

    @Override
    public String getInodeName() {
        return this.inodeName;
    }

    public void setInodeName(String inodeName) {
        this.inodeName = inodeName;
    }

    public Provenance.MLType getMlType() {
        return this.mlType;
    }

    public void setMlType(Provenance.MLType mlType) {
        this.mlType = mlType;
    }

    public String getMlId() {
        return this.mlId;
    }

    public void setMlId(String mlId) {
        this.mlId = mlId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getReadableCreateTime() {
        return this.readableCreateTime;
    }

    public void setReadableCreateTime(String readableCreateTime) {
        this.readableCreateTime = readableCreateTime;
    }

    public Map<String, String> getXattrs() {
        return this.xattrs;
    }

    public void setXattrs(Map<String, String> xattrs) {
        this.xattrs = xattrs;
    }

    public ProvAppStateDTO getAppState() {
        return this.appState;
    }

    public void setAppState(ProvAppStateDTO appState) {
        this.appState = appState;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public Long getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Long partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public Long getParentInodeId() {
        return this.parentInodeId;
    }

    public void setParentInodeId(Long parentInodeId) {
        this.parentInodeId = parentInodeId;
    }

    public void setInodeId(Long inodeId) {
        this.inodeId = inodeId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public boolean isProject() {
        return this.projectInodeId == this.inodeId;
    }
}

