/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.hops.hopsworks.common.dao.featurestore.jobs.FeaturestoreJob;
import io.hops.hopsworks.common.dao.featurestore.statistics.FeaturestoreStatistic;
import io.hops.hopsworks.common.dao.featurestore.statistics.FeaturestoreStatisticType;
import io.hops.hopsworks.common.dao.featurestore.statistics.cluster_analysis.ClusterAnalysisDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.correlation.CorrelationValueDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.correlation.FeatureCorrelationDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.correlation.FeatureCorrelationMatrixDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.descriptive.DescriptiveStatsDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.descriptive.DescriptiveStatsMetricValuesDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.distribution.FeatureDistributionDTO;
import io.hops.hopsworks.common.dao.featurestore.statistics.distribution.FeatureDistributionsDTO;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlSeeAlso(value={FeaturegroupDTO.class, TrainingDatasetDTO.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FeaturegroupDTO.class, name="FeaturegroupDTO"), @JsonSubTypes.Type(value=TrainingDatasetDTO.class, name="TrainingDatasetDTO")})
public abstract class FeaturestoreEntityDTO {
    private Integer featurestoreId;
    private String featurestoreName;
    private String description;
    private Date created;
    private String creator;
    private Integer version;
    private DescriptiveStatsDTO descriptiveStatistics;
    private FeatureCorrelationMatrixDTO featureCorrelationMatrix;
    private FeatureDistributionsDTO featuresHistogram;
    private ClusterAnalysisDTO clusterAnalysis;
    private String name;
    private Integer id;
    private List<FeatureDTO> features;
    private String location = null;
    private List<FeaturestoreJobDTO> jobs;

    public FeaturestoreEntityDTO() {
    }

    public FeaturestoreEntityDTO(Integer featurestoreId, String name, Date created, Users creator, Integer version, List<FeaturestoreStatistic> featurestoreStatistics, List<FeaturestoreJob> featurestoreJobs, Integer id) {
        this.featurestoreId = featurestoreId;
        this.created = created;
        this.creator = creator.getEmail();
        this.version = version;
        this.name = name;
        this.id = id;
        this.jobs = featurestoreJobs.stream().map(fj -> new FeaturestoreJobDTO((FeaturestoreJob)fj)).collect(Collectors.toList());
        this.clusterAnalysis = this.parseClusterAnalysis(featurestoreStatistics);
        this.featureCorrelationMatrix = this.parseFeatureCorrelation(featurestoreStatistics);
        this.descriptiveStatistics = this.parseDescriptiveStats(featurestoreStatistics);
        this.featuresHistogram = this.parseFeatureDistributions(featurestoreStatistics);
    }

    private ClusterAnalysisDTO parseClusterAnalysis(List<FeaturestoreStatistic> featurestoreStatistics) {
        List clusterAnalysisList = featurestoreStatistics.stream().filter(fss -> fss.getStatisticType() == FeaturestoreStatisticType.CLUSTERANALYSIS).collect(Collectors.toList());
        if (clusterAnalysisList.isEmpty()) {
            return null;
        }
        FeaturestoreStatistic clusterAnalysisStatistic = (FeaturestoreStatistic)clusterAnalysisList.get(0);
        return (ClusterAnalysisDTO)clusterAnalysisStatistic.getValue();
    }

    private FeatureCorrelationMatrixDTO parseFeatureCorrelation(List<FeaturestoreStatistic> featurestoreStatistics) {
        List featureCorrelationList = featurestoreStatistics.stream().filter(fss -> fss.getStatisticType() == FeaturestoreStatisticType.FEATURECORRELATIONS).collect(Collectors.toList());
        if (featureCorrelationList.isEmpty()) {
            return null;
        }
        HashMap featureCorrelations = new HashMap();
        featureCorrelationList.stream().forEach(fc -> {
            List featureCorrelationValues = featureCorrelations.getOrDefault(fc.getName(), new ArrayList());
            featureCorrelationValues.add((CorrelationValueDTO)fc.getValue());
            featureCorrelations.put(fc.getName(), featureCorrelationValues);
        });
        List<FeatureCorrelationDTO> featureCorrelationDTOS = featureCorrelations.entrySet().stream().map(entry -> {
            FeatureCorrelationDTO featureCorrelationDTO = new FeatureCorrelationDTO();
            featureCorrelationDTO.setFeatureName((String)entry.getKey());
            featureCorrelationDTO.setCorrelationValues((List)entry.getValue());
            return featureCorrelationDTO;
        }).collect(Collectors.toList());
        FeatureCorrelationMatrixDTO featureCorrelationMatrixDTO = new FeatureCorrelationMatrixDTO();
        featureCorrelationMatrixDTO.setFeatureCorrelations(featureCorrelationDTOS);
        return featureCorrelationMatrixDTO;
    }

    private DescriptiveStatsDTO parseDescriptiveStats(List<FeaturestoreStatistic> featurestoreStatistics) {
        List descriptiveStatisticsList = featurestoreStatistics.stream().filter(fss -> fss.getStatisticType() == FeaturestoreStatisticType.DESCRIPTIVESTATISTICS).collect(Collectors.toList());
        if (descriptiveStatisticsList.isEmpty()) {
            return null;
        }
        List<DescriptiveStatsMetricValuesDTO> descriptiveStatsMetricValuesDTOS = descriptiveStatisticsList.stream().map(fss -> (DescriptiveStatsMetricValuesDTO)fss.getValue()).collect(Collectors.toList());
        DescriptiveStatsDTO descriptiveStatsDTO = new DescriptiveStatsDTO();
        descriptiveStatsDTO.setDescriptiveStats(descriptiveStatsMetricValuesDTOS);
        return descriptiveStatsDTO;
    }

    private FeatureDistributionsDTO parseFeatureDistributions(List<FeaturestoreStatistic> featurestoreStatistics) {
        List featureDistributions = featurestoreStatistics.stream().filter(fss -> fss.getStatisticType() == FeaturestoreStatisticType.FEATUREDISTRIBUTIONS).collect(Collectors.toList());
        if (featureDistributions.isEmpty()) {
            return null;
        }
        List<FeatureDistributionDTO> featureDistributionDTOS = featureDistributions.stream().map(fss -> (FeatureDistributionDTO)fss.getValue()).collect(Collectors.toList());
        FeatureDistributionsDTO featureDistributionsDTO = new FeatureDistributionsDTO();
        featureDistributionsDTO.setFeatureDistributions(featureDistributionDTOS);
        return featureDistributionsDTO;
    }

    @XmlElement
    public Date getCreated() {
        return this.created;
    }

    @XmlElement
    public String getCreator() {
        return this.creator;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    @XmlElement
    public Integer getVersion() {
        return this.version;
    }

    @XmlElement
    public Integer getFeaturestoreId() {
        return this.featurestoreId;
    }

    @XmlElement
    public String getFeaturestoreName() {
        return this.featurestoreName;
    }

    @XmlElement(nillable=true)
    public FeatureCorrelationMatrixDTO getFeatureCorrelationMatrix() {
        return this.featureCorrelationMatrix;
    }

    @XmlElement(nillable=true)
    public FeatureDistributionsDTO getFeaturesHistogram() {
        return this.featuresHistogram;
    }

    @XmlElement(nillable=true)
    public ClusterAnalysisDTO getClusterAnalysis() {
        return this.clusterAnalysis;
    }

    @XmlElement(nillable=true)
    public DescriptiveStatsDTO getDescriptiveStatistics() {
        return this.descriptiveStatistics;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    @XmlElement
    public Integer getId() {
        return this.id;
    }

    @XmlElement
    public List<FeatureDTO> getFeatures() {
        return this.features;
    }

    @XmlElement
    public String getLocation() {
        return this.location;
    }

    @XmlElement(nillable=true)
    public List<FeaturestoreJobDTO> getJobs() {
        return this.jobs;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setFeatures(List<FeatureDTO> features) {
        this.features = features;
    }

    public void setFeaturestoreName(String featurestoreName) {
        this.featurestoreName = featurestoreName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescriptiveStatistics(DescriptiveStatsDTO descriptiveStatistics) {
        this.descriptiveStatistics = descriptiveStatistics;
    }

    public void setFeatureCorrelationMatrix(FeatureCorrelationMatrixDTO featureCorrelationMatrix) {
        this.featureCorrelationMatrix = featureCorrelationMatrix;
    }

    public void setFeaturesHistogram(FeatureDistributionsDTO featuresHistogram) {
        this.featuresHistogram = featuresHistogram;
    }

    public void setClusterAnalysis(ClusterAnalysisDTO clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setFeaturestoreId(Integer featurestoreId) {
        this.featurestoreId = featurestoreId;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setJobs(List<FeaturestoreJobDTO> jobs) {
        this.jobs = jobs;
    }

    public String toString() {
        return "FeaturestoreEntityDTO{featurestoreId=" + this.featurestoreId + ", featurestoreName='" + this.featurestoreName + '\'' + ", description='" + this.description + '\'' + ", created='" + this.created + '\'' + ", creator='" + this.creator + '\'' + ", version=" + this.version + ", descriptiveStatistics=" + this.descriptiveStatistics + ", featureCorrelationMatrix=" + this.featureCorrelationMatrix + ", featuresHistogram=" + this.featuresHistogram + ", clusterAnalysis=" + this.clusterAnalysis + ", name='" + this.name + '\'' + ", id=" + this.id + '}';
    }
}

