/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.jobhistory;

import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;

public enum JobState {
    INITIALIZING("Initializing"),
    INITIALIZATION_FAILED("Initialization failed"),
    FINISHED("Finished"),
    RUNNING("Running"),
    ACCEPTED("Accepted"),
    FAILED("Failed"),
    KILLED("Killed"),
    NEW("New"),
    NEW_SAVING("New, saving"),
    SUBMITTED("Submitted"),
    AGGREGATING_LOGS("Aggregating logs"),
    FRAMEWORK_FAILURE("Framework failure"),
    STARTING_APP_MASTER("Starting Application Master"),
    APP_MASTER_START_FAILED("Failed starting AM"),
    GENERATING_SECURITY_MATERIAL("Generating security material");

    private final String readable;

    private JobState(String readable) {
        this.readable = readable;
    }

    public String toString() {
        return this.readable;
    }

    public static JobState getJobState(YarnApplicationState yarnstate) {
        switch (yarnstate) {
            case RUNNING: {
                return RUNNING;
            }
            case ACCEPTED: {
                return ACCEPTED;
            }
            case FAILED: {
                return FAILED;
            }
            case FINISHED: {
                return FINISHED;
            }
            case KILLED: {
                return KILLED;
            }
            case NEW: {
                return NEW;
            }
            case NEW_SAVING: {
                return NEW_SAVING;
            }
            case SUBMITTED: {
                return SUBMITTED;
            }
            case GENERATING_SECURITY_MATERIAL: {
                return GENERATING_SECURITY_MATERIAL;
            }
        }
        throw new IllegalArgumentException("Invalid enum constant");
    }

    public boolean isFinalState() {
        switch (this) {
            case FINISHED: 
            case FAILED: 
            case KILLED: 
            case FRAMEWORK_FAILURE: 
            case APP_MASTER_START_FAILED: 
            case INITIALIZATION_FAILED: {
                return true;
            }
        }
        return false;
    }

    public static Set<JobState> getRunningStates() {
        return EnumSet.of(INITIALIZING, new JobState[]{NEW, NEW_SAVING, GENERATING_SECURITY_MATERIAL, SUBMITTED, ACCEPTED, STARTING_APP_MASTER, RUNNING, AGGREGATING_LOGS});
    }

    public static Set<JobState> getFinalStates() {
        return EnumSet.of(FINISHED, new JobState[]{FAILED, KILLED, FRAMEWORK_FAILURE, APP_MASTER_START_FAILED, INITIALIZATION_FAILED});
    }
}

