/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.exceptions.ProvenanceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.javatuples.Pair;

public class ProvTree {
    public static <S extends State> void merge(Builder<S> to, Builder<S> from) {
        if (to.getInodeId() == null) {
            to.setInodeId(from.getInodeId());
        }
        if (to.getName() == null) {
            to.setName(from.getName());
        }
        if (to.getFileState() == null) {
            to.setFileState(from.getFileState());
        }
    }

    public static class AuxStruct<S extends State> {
        Supplier<Builder<S>> instanceBuilder;
        ArrayList<Long> findInInodes = new ArrayList();
        ArrayList<Long> pendingInInodes = new ArrayList();
        ArrayList<Long> notFound = new ArrayList();
        TreeMap<Long, Builder<S>> allNodes = new TreeMap();
        TreeMap<Long, Builder<S>> incompleteNodes = new TreeMap();
        TreeMap<Long, Builder<S>> projectNodes = new TreeMap();

        public AuxStruct(Supplier<Builder<S>> instanceBuilder) {
            this.instanceBuilder = instanceBuilder;
        }

        public Pair<Map<Long, Builder<S>>, Map<Long, Builder<S>>> getMinTree() {
            return Pair.with(this.incompleteNodes, new HashMap());
        }

        public Pair<Map<Long, Builder<S>>, Map<Long, Builder<S>>> getFullTree() {
            return Pair.with(this.projectNodes, this.incompleteNodes);
        }

        public void processBasicFileState(List<S> fileStates) throws ProvenanceException {
            for (State fileState : fileStates) {
                if (fileState.isProject()) {
                    Builder<State> projectNode = this.getOrBuildProjectNode(fileState);
                    projectNode.setFileState(fileState);
                    continue;
                }
                Builder<State> parentNode = this.getOrBuildParentNode(fileState);
                Builder<State> node = this.getOrBuildNode(fileState);
                parentNode.addChild(node);
            }
        }

        private Builder<S> getOrBuildProjectNode(S fileState) {
            Builder<S> projectNode = this.projectNodes.get(fileState.getProjectInodeId());
            if (projectNode == null) {
                projectNode = this.instanceBuilder.get();
                projectNode.setInodeId(fileState.getProjectInodeId());
                this.allNodes.put(projectNode.getInodeId(), projectNode);
                this.projectNodes.put(projectNode.getInodeId(), projectNode);
                this.findInInodes.add(projectNode.getInodeId());
            }
            return projectNode;
        }

        private Builder<S> getOrBuildParentNode(S fileState) {
            this.getOrBuildProjectNode(fileState);
            Builder<S> parentNode = this.getOrBuildParentNode(fileState.getParentInodeId());
            return parentNode;
        }

        private Builder<S> getOrBuildParentNode(Long parentInodeId) {
            Builder<S> parentNode = this.allNodes.get(parentInodeId);
            if (parentNode == null) {
                parentNode = this.instanceBuilder.get();
                parentNode.setInodeId(parentInodeId);
                this.allNodes.put(parentNode.getInodeId(), parentNode);
                if (!this.projectNodes.containsKey(parentNode.getInodeId())) {
                    this.findInInodes.add(parentNode.getInodeId());
                    this.incompleteNodes.put(parentNode.getInodeId(), parentNode);
                }
            }
            return parentNode;
        }

        private Builder<S> getOrBuildNode(S fileState) {
            this.incompleteNodes.remove(fileState.getInodeId());
            this.findInInodes.remove(fileState.getInodeId());
            Builder<S> node = this.allNodes.get(fileState.getInodeId());
            if (node == null) {
                node = this.instanceBuilder.get();
                node.setInodeId(fileState.getInodeId());
                this.allNodes.put(node.getInodeId(), node);
            }
            node.setName(fileState.getInodeName());
            node.setFileState(fileState);
            return node;
        }

        public boolean findInInodes() {
            return !this.findInInodes.isEmpty();
        }

        public boolean complete() {
            return this.findInInodes.isEmpty();
        }

        public List<Long> nextFindInInodes() {
            int batchSize = Math.min(100, this.findInInodes.size());
            ArrayList<Long> batch = new ArrayList<Long>(this.findInInodes.subList(0, batchSize));
            this.findInInodes.removeAll(batch);
            this.pendingInInodes.addAll(batch);
            return batch;
        }

        public void processInodeBatch(List<Long> inodeBatch, List<Inode> inodes) throws ProvenanceException {
            this.pendingInInodes.removeAll(inodeBatch);
            HashSet<Long> inodesNotFound = new HashSet<Long>(inodeBatch);
            for (Inode inode : inodes) {
                inodesNotFound.remove(inode.getId());
                Builder<S> node = this.incompleteNodes.remove(inode.getId());
                if (node != null) {
                    node.setName(inode.getInodePK().getName());
                    Builder<S> parentNode = this.getOrBuildParentNode(inode.getInodePK().getParentId());
                    parentNode.addChild(node);
                    continue;
                }
                node = this.projectNodes.get(inode.getId());
                if (node == null) continue;
                node.setName(inode.getInodePK().getName());
            }
            this.notFound.addAll(inodesNotFound);
        }
    }

    public static interface Builder<S extends State> {
        public void setInodeId(Long var1);

        public Long getInodeId();

        public void setName(String var1);

        public String getName();

        public void setFileState(S var1);

        public S getFileState();

        public void addChild(Builder<S> var1) throws ProvenanceException;
    }

    public static interface State {
        public Long getInodeId();

        public String getInodeName();

        public Long getProjectInodeId();

        public boolean isProject();

        public Long getParentInodeId();
    }
}

