/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.rstudio;

import io.hops.hopsworks.common.dao.rstudio.RStudioSettings;
import io.hops.hopsworks.common.dao.rstudio.RStudioSettingsPK;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.codec.digest.DigestUtils;

@Stateless
public class RStudioSettingsFacade {
    private static final Logger logger = Logger.getLogger(RStudioSettingsFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<RStudioSettings> findJupyterSettingsByProject(Integer projectId) {
        TypedQuery query = this.em.createNamedQuery("JupyterSettings.findByProjectId", RStudioSettings.class);
        query.setParameter("projectId", (Object)projectId);
        return query.getResultList();
    }

    public RStudioSettings findByProjectUser(int projectId, String email) {
        RStudioSettingsPK pk = new RStudioSettingsPK(projectId, email);
        RStudioSettings js = null;
        js = (RStudioSettings)this.em.find(RStudioSettings.class, (Object)pk);
        if (js == null) {
            String secret = DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt()));
            js = new RStudioSettings(pk);
            js.setSecret(secret);
            js.setMode("sparkDynamic");
            this.persist(js);
        }
        return js;
    }

    private void persist(RStudioSettings js) {
        if (js != null) {
            this.em.persist((Object)js);
        }
    }

    public void update(RStudioSettings js) {
        if (js != null) {
            this.em.merge((Object)js);
        }
    }

    private void remove(RStudioSettings js) {
        if (js != null) {
            this.em.remove((Object)js);
        }
    }
}

